/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.LockAdminUserRight;
import org.openconcerto.sql.users.rights.MacroRight;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.Tuple2;

public class UserRightsManager {
    private static UserRightsManager instance;
    private static final CollectionMap<String, Tuple2<String, Boolean>> SUPERUSER_RIGHTS;
    private final Map<String, MacroRight> macroRights = new HashMap<String, MacroRight>();
    private final Map<Integer, CollectionMap<String, Tuple2<String, Boolean>>> rights = new HashMap<Integer, CollectionMap<String, Tuple2<String, Boolean>>>();
    private SQLTable table = null;
    private final CollectionMap<Integer, RightTuple> javaRights = new CollectionMap();

    static {
        SUPERUSER_RIGHTS = CollectionMap.singleton(null, Tuple2.create(null, true));
    }

    public static synchronized UserRightsManager getInstance() {
        if (instance == null) {
            instance = new UserRightsManager();
        }
        return instance;
    }

    private UserRightsManager() {
        this.defaultRegister();
    }

    private void defaultRegister() {
        this.register(new LockAdminUserRight());
        this.register(new TableAllRights(true));
        this.register(new TableAllRights(false));
    }

    public void register(MacroRight userRight) {
        this.macroRights.put(userRight.getCode(), userRight);
    }
}

