/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class UpdateBuilder {
    private final SQLTable t;
    private final Map<String, String> fields;
    private final List<String> tables;
    private Where where;

    public UpdateBuilder(SQLTable t) {
        this.t = t;
        this.fields = new LinkedHashMap<String, String>();
        this.tables = new ArrayList<String>();
    }

    public final SQLTable getTable() {
        return this.t;
    }

    public final UpdateBuilder set(String field, String value) {
        if (!this.getTable().contains(field)) {
            throw new IllegalArgumentException("unknown " + field + " in " + this.getTable().getSQLName());
        }
        this.fields.put(field, value);
        return this;
    }

    public final void setWhere(Where where) {
        this.where = where;
    }

    public final void addTable(String definition, String alias) {
        this.tables.add(String.valueOf(definition) + (alias == null ? "" : " " + alias));
    }

    public final String asString() {
        String w = this.where == null ? "" : "\nWHERE " + this.where.getClause();
        return "UPDATE " + this.getTable().getServer().getSQLSystem().getSyntax().getUpdate(this.getTable(), Collections.unmodifiableList(this.tables), Collections.unmodifiableMap(this.fields)) + w;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.asString();
    }
}

