/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;

final class SQLTableListenerData<R extends SQLRowAccessor>
implements SQLTableListener {
    private final R row;
    private final SQLDataListener l;

    SQLTableListenerData(R row, SQLDataListener l) {
        this.row = row;
        this.l = l;
    }

    @Override
    public void rowAdded(SQLTable table, int id) {
        if (((SQLRowAccessor)this.row).getID() == id) {
            this.l.dataChanged();
        }
    }

    @Override
    public void rowDeleted(SQLTable table, int id) {
        if (id < 0 || ((SQLRowAccessor)this.row).getID() == id) {
            this.l.dataChanged();
        }
    }

    @Override
    public void rowModified(SQLTable table, int id) {
        if (id < 0 || ((SQLRowAccessor)this.row).getID() == id) {
            this.l.dataChanged();
        }
    }
}

