/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.dbutils.ResultSetHandler;
import org.jdom.Element;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.JDBCStructureSource;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.SystemQueryExecutor;
import org.openconcerto.sql.model.Trigger;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.change.CollectionChangeEventCreator;
import org.openconcerto.xml.JDOMUtils;

public final class SQLTable
extends SQLIdentifier
implements SQLData {
    private static final Map<SQLSchema, Map<String, Number>> UNDEFINED_IDs = new HashMap<SQLSchema, Map<String, Number>>();
    private final ListOrderedMap fields;
    private final Set<SQLField> primaryKeys;
    private SQLField primaryKey = null;
    private boolean primaryKeyOK = true;
    private Set<SQLField> keys = null;
    private final Map<String, Trigger> triggers;
    private Set<Constraint> constraints;
    private List<SQLTableModifiedListener> tableModifiedListeners = Collections.emptyList();
    private final List<SQLTableListener> listeners = new ArrayList<SQLTableListener>();
    private final List<SQLTableListener> dispatchingListeners = new ArrayList<SQLTableListener>();
    private Integer undefinedID = null;
    private String comment;
    private String type;
    private int dispatchingID = -2;

    private static final Map<String, Number> getUndefIDs(final SQLSchema schema) {
        if (!UNDEFINED_IDs.containsKey(schema)) {
            Map r;
            if (schema.contains("FWK_UNDEFINED_IDS")) {
                SQLBase b = schema.getBase();
                final SQLTable undefT = schema.getTable("FWK_UNDEFINED_IDS");
                SQLSelect sel = new SQLSelect(b).addSelectStar(undefT);
                r = (Map)b.getDataSource().execute(sel.asString(), new ResultSetHandler(){

                    @Override
                    public Object handle(ResultSet rs) throws SQLException {
                        HashMap<String, Number> res = new HashMap<String, Number>();
                        while (rs.next()) {
                            res.put(rs.getString("TABLENAME"), (Number)rs.getObject("UNDEFINED_ID"));
                        }
                        return res;
                    }
                });
                undefT.addTableModifiedListener(new SQLTableModifiedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void tableModified(SQLTableEvent evt) {
                        Map map = UNDEFINED_IDs;
                        synchronized (map) {
                            UNDEFINED_IDs.remove(schema);
                            undefT.removeTableModifiedListener(this);
                        }
                    }
                });
            } else {
                r = Collections.emptyMap();
            }
            UNDEFINED_IDs.put(schema, r);
        }
        return UNDEFINED_IDs.get(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Number getUndefID(SQLSchema b, String tableName) {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            return SQLTable.getUndefIDs(b).get(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean containsUndefID(SQLSchema b, String tableName) {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            return SQLTable.getUndefIDs(b).containsKey(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setUndefID(SQLSchema schema, String tableName, Integer value) throws SQLException {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            boolean modified;
            SQLTable undefT = schema.getTable("FWK_UNDEFINED_IDS");
            String sql = undefT.getField("UNDEFINED_ID").getType().toString(value);
            if (!SQLTable.containsUndefID(schema, tableName)) {
                SQLRowValues.insertCount(undefT, "(\"TABLENAME\", \"UNDEFINED_ID\") VALUES(" + schema.getBase().quoteString(tableName) + ", " + sql + ")");
                modified = true;
            } else if (!CompareUtils.equals(SQLTable.getUndefID(schema, tableName), value)) {
                UpdateBuilder update = new UpdateBuilder(undefT).set("UNDEFINED_ID", sql);
                update.setWhere(new Where((FieldRef)undefT.getField("TABLENAME"), "=", tableName));
                schema.getDBSystemRoot().getDataSource().execute(update.asString());
                modified = true;
            } else {
                modified = false;
            }
            if (modified) {
                schema.updateVersion();
                undefT.fireTableModified(-1);
            }
        }
    }

    private static ListOrderedMap createMap() {
        return (ListOrderedMap)ListOrderedMap.decorate(new CaseInsensitiveMap());
    }

    SQLTable(SQLSchema schema, String name) {
        super(schema, name);
        this.fields = SQLTable.createMap();
        this.primaryKeys = new LinkedHashSet<SQLField>();
        this.triggers = new HashMap<String, Trigger>();
        this.constraints = new HashSet<Constraint>();
    }

    void clearNonPersistent() {
        this.triggers.clear();
        this.constraints = new HashSet<Constraint>();
    }

    void loadFields(Element xml) {
        Element constraintsElem;
        LinkedHashMap<String, SQLField> newFields = new LinkedHashMap<String, SQLField>();
        for (Element elementField : xml.getChildren("field")) {
            SQLField f = SQLField.create(this, elementField);
            newFields.put(f.getName(), f);
        }
        Element primary = xml.getChild("primary");
        ArrayList<String> newPrimaryKeys = new ArrayList<String>();
        for (Element elementField : primary.getChildren("field")) {
            String fieldName = elementField.getAttributeValue("name");
            newPrimaryKeys.add(fieldName);
        }
        String undefAttr = xml.getAttributeValue("undefID");
        this.setState(newFields, newPrimaryKeys, undefAttr == null ? null : Integer.valueOf(undefAttr));
        Element triggersElem = xml.getChild("triggers");
        if (triggersElem != null) {
            for (Element triggerElem : triggersElem.getChildren()) {
                this.addTrigger(Trigger.fromXML(this, triggerElem));
            }
        }
        if ((constraintsElem = xml.getChild("constraints")) == null) {
            this.addConstraint((Constraint)null);
        } else {
            for (Element elem : constraintsElem.getChildren()) {
                this.addConstraint(Constraint.fromXML(this, elem));
            }
        }
        Element commentElem = xml.getChild("comment");
        if (commentElem != null) {
            this.setComment(commentElem.getText());
        }
        this.setType(xml.getAttributeValue("type"));
    }

    private void addTrigger(Trigger t) {
        this.triggers.put(t.getName(), t);
    }

    private void addConstraint(Constraint c) {
        if (c == null) {
            this.constraints = null;
        } else {
            if (this.constraints == null) {
                this.constraints = new HashSet<Constraint>();
            }
            this.constraints.add(c);
        }
    }

    public void fetchFields() throws SQLException {
        this.getBase().getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                DatabaseMetaData metaData = ds.getConnection().getMetaData();
                ResultSet rs = metaData.getColumns(SQLTable.this.getBase().getMDName(), SQLTable.this.getSchema().getName(), SQLTable.this.getName(), null);
                if (!rs.next()) {
                    SQLTable.this.emptyFields();
                } else {
                    SQLTable.this.fetchFields(metaData, rs);
                }
                ResultSet tableRS = metaData.getTables(SQLTable.this.getBase().getMDName(), SQLTable.this.getSchema().getName(), SQLTable.this.getName(), new String[]{"TABLE", "SYSTEM TABLE", "VIEW"});
                if (!tableRS.next()) {
                    SQLTable.this.setType(null);
                    SQLTable.this.setComment(null);
                } else {
                    SQLTable.this.setType(tableRS.getString("TABLE_TYPE"));
                    SQLTable.this.setComment(tableRS.getString("REMARKS"));
                }
                return null;
            }
        });
        this.clearNonPersistent();
        new JDBCStructureSource.TriggerQueryExecutor(null).apply(this);
        new JDBCStructureSource.ColumnsQueryExecutor(null).apply(this);
        try {
            new JDBCStructureSource.ConstraintsExecutor(null).apply(this);
        }
        catch (SystemQueryExecutor.QueryExn e) {
            e.printStackTrace();
            this.addConstraint((Constraint)null);
        }
        this.getDBSystemRoot().descendantsChanged(false);
        this.save();
    }

    boolean fetchFields(DatabaseMetaData metaData, ResultSet rs) throws SQLException {
        if (!this.isUs(rs)) {
            throw new IllegalStateException("rs current row does not describe " + this);
        }
        LinkedHashMap<String, SQLField> newFields = new LinkedHashMap<String, SQLField>();
        boolean hasNext = true;
        while (hasNext && this.isUs(rs)) {
            SQLField f = SQLField.create(this, rs);
            newFields.put(f.getName(), f);
            hasNext = rs.next();
        }
        ArrayList<String> newPrimaryKeys = new ArrayList<String>();
        ResultSet pkRS = metaData.getPrimaryKeys(this.getBase().getMDName(), this.getSchema().getName(), this.getName());
        while (pkRS.next()) {
            newPrimaryKeys.add(pkRS.getString("COLUMN_NAME"));
        }
        this.setState(newFields, newPrimaryKeys, null);
        return hasNext;
    }

    void emptyFields() {
        this.setState(new LinkedHashMap<String, SQLField>(), Collections.<String>emptyList(), null);
    }

    private boolean isUs(ResultSet rs) throws SQLException {
        String n = rs.getString("TABLE_NAME");
        String s = rs.getString("TABLE_SCHEM");
        return n.equals(this.getName()) && CompareUtils.equals(s, this.getSchema().getName());
    }

    void addTrigger(Map m) {
        this.addTrigger(new Trigger(this, m));
    }

    void addConstraint(Map<String, Object> m) {
        this.addConstraint(m == null ? null : new Constraint(this, m));
    }

    private int fetchUndefID() {
        Number id;
        int res = this.isRowable() ? (!SQLTable.containsUndefID(this.getSchema(), this.getName()) ? this.findMinID() : ((id = SQLTable.getUndefID(this.getSchema(), this.getName())) == null ? -1 : id.intValue())) : -1;
        return res;
    }

    private int findMinID() {
        String debugUndef = "fwk_sql.debug.undefined_id";
        if (System.getProperty("fwk_sql.debug.undefined_id") != null) {
            Log.get().warning("The system property 'fwk_sql.debug.undefined_id' is deprecated, use the 'undefined ID policy' metadata");
        }
        String policy = this.getSchema().getFwkMetadata("undefined ID policy");
        if (Boolean.getBoolean("fwk_sql.debug.undefined_id") || "min".equals(policy)) {
            SQLSelect sel = new SQLSelect(this.getBase(), true).addSelect(this.getKey(), "min");
            Number undef = (Number)this.getBase().getDataSource().executeScalar(sel.asString());
            if (undef == null) {
                throw new IllegalStateException(this + " is empty, can not infer UNDEFINED_ID");
            }
            String update = "INSERT into " + new SQLName(this.getDBRoot().getName(), "FWK_UNDEFINED_IDS") + " VALUES('" + this.getName() + "', " + undef + ");";
            Log.get().config("the first row (which should be the undefined):\n" + update);
            return undef.intValue();
        }
        if (policy != null && !"nonexistant".equals(policy)) {
            int res = Integer.parseInt(policy);
            if (res < 0) {
                throw new IllegalStateException("ID is not valid : " + res);
            }
            return res;
        }
        return -1;
    }

    void mutateTo(SQLTable table) {
        this.clearNonPersistent();
        this.setState(table.fields, table.getPKsNames(), table.undefinedID);
        this.triggers.putAll(table.triggers);
        if (table.constraints == null) {
            this.constraints = null;
        } else {
            this.constraints.addAll(table.constraints);
        }
        this.setType(table.getType());
        this.setComment(table.getComment());
    }

    private void setState(Map<String, SQLField> fields, List<String> primaryKeys, Integer undef) {
        if (!(fields instanceof LinkedHashMap) && !(fields instanceof OrderedMap)) {
            throw new IllegalArgumentException("fields is of class " + fields.getClass());
        }
        for (SQLField newField : fields.values()) {
            if (newField.getTable().getSQLName().equals(this.getSQLName())) continue;
            throw new IllegalArgumentException(newField + " is in table " + newField.getTable().getSQLName() + " not us: " + this.getSQLName());
        }
        CollectionChangeEventCreator c = this.createChildrenCreator();
        if (!fields.keySet().containsAll(this.getFieldsName())) {
            for (String removed : CollectionUtils.substract(this.getFieldsName(), fields.keySet())) {
                ((SQLField)this.fields.remove(removed)).dropped();
            }
        }
        for (SQLField newField : fields.values()) {
            if (this.getChildrenNames().contains(newField.getName())) {
                this.getField(newField.getName()).mutateTo(newField);
                continue;
            }
            SQLField fieldToAdd = newField.getTable() != this ? new SQLField(this, newField) : newField;
            this.fields.put(newField.getName(), fieldToAdd);
        }
        this.primaryKeys.clear();
        for (String pk : primaryKeys) {
            this.primaryKeys.add(this.getField(pk));
        }
        this.primaryKey = primaryKeys.size() == 1 ? this.getField(primaryKeys.get(0)) : null;
        this.primaryKeyOK = primaryKeys.size() <= 1;
        this.undefinedID = undef;
        this.fireChildrenChanged(c);
    }

    void setType(String type) {
        this.type = type;
    }

    public final String getType() {
        return this.type;
    }

    void setComment(String comm) {
        this.comment = comm;
    }

    public final String getComment() {
        return this.comment;
    }

    public final Constraint getConstraint(SQLSyntax.ConstraintType type, List<String> cols) {
        if (this.constraints == null) {
            return null;
        }
        for (Constraint c : this.constraints) {
            if (c.getType() != type || !c.getCols().equals(cols)) continue;
            return c;
        }
        return null;
    }

    public boolean isRowable() {
        return this.getPrimaryKeys().size() == 1 && Number.class.isAssignableFrom(this.getKey().getType().getJavaType());
    }

    public SQLSchema getSchema() {
        return (SQLSchema)this.getParent();
    }

    public SQLBase getBase() {
        return this.getSchema().getBase();
    }

    public SQLField getKey() {
        if (!this.primaryKeyOK) {
            throw new IllegalStateException(this + " has more than 1 primary key: " + this.getPrimaryKeys());
        }
        return this.primaryKey;
    }

    public Set<SQLField> getPrimaryKeys() {
        return Collections.unmodifiableSet(this.primaryKeys);
    }

    public Set<SQLField> getForeignKeys() {
        return this.getDBSystemRoot().getGraph().getForeignKeys(this);
    }

    public Set<String> getForeignKeysNames() {
        return DatabaseGraph.getNames(this.getDBSystemRoot().getGraph().getForeignLinks(this));
    }

    public Set<SQLField> getForeignKeys(SQLTable foreignTable) {
        return this.getDBSystemRoot().getGraph().getForeignFields(this, foreignTable);
    }

    public String toString() {
        return "/" + this.getName() + "/";
    }

    public SQLField getField(String fieldName) {
        SQLField res = this.getFieldRaw(fieldName);
        if (res == null) {
            throw new IllegalArgumentException("unknown field " + fieldName + " in " + this.getName() + ". The table " + this.getName() + " contains the followins fields: " + this.fields.asList());
        }
        return res;
    }

    public SQLField getFieldRaw(String fieldName) {
        return (SQLField)this.fields.get(fieldName);
    }

    public Set<SQLField> getFields() {
        return new HashSet<SQLField>(this.fields.values());
    }

    public Set<String> getFieldsName() {
        return this.fields.keySet();
    }

    public List<SQLField> getOrderedFields() {
        return new ArrayList<SQLField>(this.fields.values());
    }

    @Override
    public SQLIdentifier getChild(String name) {
        return this.getField(name);
    }

    @Override
    public Set<String> getChildrenNames() {
        return this.getFieldsName();
    }

    public final SQLTable getTable(String name) {
        return this.getDesc(name, SQLTable.class);
    }

    public SQLRow getRow(int ID) {
        SQLRow row = this.getUncheckedRow(ID);
        return row.exists() ? row : null;
    }

    private SQLRow getUncheckedRow(int ID) {
        return new SQLRow(this, ID);
    }

    public SQLRow checkValidity(int ID) {
        SQLRow row = this.getUncheckedRow(ID);
        return row.isValid() ? null : row;
    }

    public SQLRow checkValidity(String foreignKey, int foreignID) {
        SQLField fk = this.getField(foreignKey);
        SQLTable foreignTable = this.getDBSystemRoot().getGraph().getForeignTable(fk);
        if (foreignTable == null) {
            throw new IllegalArgumentException("Impossible de tester '" + foreignKey + "' avec " + foreignID + " dans " + this + ". Ce n'est pas une clef \u00e9trang\u00e8re.");
        }
        return foreignTable.checkValidity(foreignID);
    }

    public SQLRow checkValidity(String foreignKey, Number foreignID) {
        if (foreignID == null) {
            return null;
        }
        return this.checkValidity(foreignKey, foreignID.intValue());
    }

    public boolean isOrdered() {
        return this.getOrderField() != null;
    }

    public SQLField getOrderField() {
        return this.getFieldRaw("ORDRE");
    }

    public boolean isArchivable() {
        return this.getArchiveField() != null;
    }

    public SQLField getArchiveField() {
        return this.getFieldRaw("ARCHIVE");
    }

    public SQLField getCreationDateField() {
        return this.getFieldRaw("CREATION_DATE");
    }

    public SQLField getCreationUserField() {
        return this.getFieldRaw("ID_USER_COMMON_CREATE");
    }

    public SQLField getModifDateField() {
        return this.getFieldRaw("MODIFICATION_DATE");
    }

    public SQLField getModifUserField() {
        return this.getFieldRaw("ID_USER_COMMON_MODIFY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getUndefinedID() {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            if (this.undefinedID == null) {
                if (this.getSchema().isFetchAllUndefinedIDs()) {
                    for (SQLTable sibling : this.getSchema().getTables()) {
                        if (sibling.undefinedID != null) continue;
                        sibling.undefinedID = sibling.fetchUndefID();
                    }
                    this.getBase().save(this.getSchema().getName());
                } else {
                    this.undefinedID = this.fetchUndefID();
                    this.save();
                }
            }
            return this.undefinedID;
        }
    }

    private final void save() {
        this.getBase().save(this.getSchema().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableModifiedListener(SQLTableModifiedListener l) {
        List<SQLTableListener> list = this.listeners;
        synchronized (list) {
            ArrayList<SQLTableModifiedListener> newListeners = new ArrayList<SQLTableModifiedListener>(this.tableModifiedListeners);
            newListeners.add(l);
            this.tableModifiedListeners = Collections.unmodifiableList(newListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableModifiedListener(SQLTableModifiedListener l) {
        List<SQLTableListener> list = this.listeners;
        synchronized (list) {
            ArrayList<SQLTableModifiedListener> newListeners = new ArrayList<SQLTableModifiedListener>(this.tableModifiedListeners);
            if (newListeners.remove(l)) {
                this.tableModifiedListeners = Collections.unmodifiableList(newListeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPremierTableListener(SQLTableListener l) {
        List<SQLTableListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(l)) {
                throw new IllegalStateException(l + " is already listener of " + this);
            }
            this.listeners.add(0, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableListener(SQLTableListener l) {
        List<SQLTableListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public void fireTableModified(int id) {
        this.fire(SQLTableEvent.Mode.ROW_UPDATED, id);
    }

    public void fireRowDeleted(int id) {
        this.fire(SQLTableEvent.Mode.ROW_DELETED, id);
    }

    public void fireTableModified(int id, Collection<String> fields) {
        this.fire(new SQLTableEvent(this, id, SQLTableEvent.Mode.ROW_UPDATED, fields));
    }

    private void fire(SQLTableEvent.Mode mode, int id) {
        this.fire(new SQLTableEvent(this, id, mode, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fire(SQLTableEvent evt) {
        int id = evt.getId();
        List<SQLTableListener> list = this.dispatchingListeners;
        synchronized (list) {
            if (this.dispatchingID != id) {
                this.dispatchingID = id;
                SQLTableEvent.Mode mode = evt.getMode();
                this.dispatchingListeners.clear();
                List<SQLTableListener> list2 = this.listeners;
                synchronized (list2) {
                    this.dispatchingListeners.addAll(this.listeners);
                }
                int size = this.dispatchingListeners.size();
                int i = 0;
                while (i < size) {
                    SQLTableListener obj = this.dispatchingListeners.get(i);
                    if (mode == SQLTableEvent.Mode.ROW_UPDATED) {
                        obj.rowModified(this, id);
                    } else if (mode == SQLTableEvent.Mode.ROW_ADDED) {
                        obj.rowAdded(this, id);
                    } else if (mode == SQLTableEvent.Mode.ROW_DELETED) {
                        obj.rowDeleted(this, id);
                    } else {
                        throw new IllegalArgumentException("unknown mode: " + (Object)((Object)mode));
                    }
                    ++i;
                }
                this.fireTableModified(evt);
                this.dispatchingID = -2;
            } else {
                System.err.println("dropping a SQLTable.fire() : fired in the listener");
                Thread.dumpStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableModified(SQLTableEvent evt) {
        List<SQLTableModifiedListener> dispatchingListeners;
        List<SQLTableListener> list = this.listeners;
        synchronized (list) {
            dispatchingListeners = this.tableModifiedListeners;
        }
        for (SQLTableModifiedListener l : dispatchingListeners) {
            l.tableModified(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder sb = new StringBuilder(16000);
        sb.append("<table name=\"");
        sb.append(this.getName());
        sb.append("\"");
        String schemaName = this.getSchema().getName();
        if (schemaName != null) {
            sb.append(" schema=\"");
            sb.append(schemaName);
            sb.append('\"');
        }
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            if (this.undefinedID != null) {
                sb.append(" undefID=\"");
                sb.append(this.undefinedID);
                sb.append('\"');
            }
        }
        if (this.getType() != null) {
            sb.append(" type=\"");
            sb.append(this.getType());
            sb.append('\"');
        }
        sb.append(">\n");
        if (this.getComment() != null) {
            sb.append("<comment>");
            sb.append(JDOMUtils.OUTPUTTER.escapeElementEntities(this.getComment()));
            sb.append("</comment>\n");
        }
        for (SQLField sQLField : this.fields.values()) {
            sb.append(sQLField.toXML());
        }
        sb.append("<primary>\n");
        for (SQLField sQLField : this.primaryKeys) {
            sb.append(sQLField.toXML());
        }
        sb.append("</primary>\n");
        if (this.triggers.size() > 0) {
            sb.append("<triggers>\n");
            for (Trigger trigger : this.triggers.values()) {
                sb.append(trigger.toXML());
            }
            sb.append("</triggers>\n");
        }
        if (this.constraints != null) {
            sb.append("<constraints>\n");
            for (Constraint constraint : this.constraints) {
                sb.append(constraint.toXML());
            }
            sb.append("</constraints>\n");
        }
        sb.append("</table>");
        return sb.toString();
    }

    @Override
    public SQLTableListener createTableListener(final SQLDataListener l) {
        return new SQLTableListener(){

            @Override
            public void rowModified(SQLTable table, int id) {
                l.dataChanged();
            }

            @Override
            public void rowAdded(SQLTable table, int id) {
                l.dataChanged();
            }

            @Override
            public void rowDeleted(SQLTable table, int id) {
                l.dataChanged();
            }
        };
    }

    @Override
    public SQLTable getTable() {
        return this;
    }

    public final List<String> getPKsNames() {
        return this.getPKsNames(new ArrayList());
    }

    public final <C extends Collection<String>> C getPKsNames(C pks) {
        for (SQLField f : this.getPrimaryKeys()) {
            pks.add((String)f.getName());
        }
        return pks;
    }

    public final List<Index> getIndexes() throws SQLException {
        Set<List<String>> uniqConstraints;
        if (this.constraints != null) {
            uniqConstraints = new HashSet();
            for (Constraint c : this.constraints) {
                if (c.getType() != SQLSyntax.ConstraintType.UNIQUE) continue;
                uniqConstraints.add(c.getCols());
            }
        } else {
            uniqConstraints = Collections.emptySet();
        }
        ArrayList<Index> indexes = new ArrayList<Index>();
        Index currentIndex = null;
        for (Map<String, Object> norm : this.getServer().getSQLSystem().getSyntax().getIndexInfo(this)) {
            Index index = new Index(norm);
            short seq = ((Number)norm.get("ORDINAL_POSITION")).shortValue();
            if (seq == 1) {
                if (this.canAdd(currentIndex, uniqConstraints)) {
                    indexes.add(currentIndex);
                }
                currentIndex = index;
                continue;
            }
            currentIndex.add(index);
        }
        if (this.canAdd(currentIndex, uniqConstraints)) {
            indexes.add(currentIndex);
        }
        return indexes;
    }

    private boolean canAdd(Index currentIndex, Set<List<String>> uniqConstraints) {
        if (currentIndex == null || currentIndex.isPKIndex()) {
            return false;
        }
        return !currentIndex.isUnique() || !uniqConstraints.contains(currentIndex.getCols());
    }

    public final class Index {
        private final String name;
        private final List<String> attrs;
        private final List<String> cols;
        private final boolean unique;
        private String method;
        private String filter;

        Index(Map<String, Object> row) {
            this((String)row.get("INDEX_NAME"), (String)row.get("COLUMN_NAME"), (Boolean)row.get("NON_UNIQUE"), (String)row.get("FILTER_CONDITION"));
        }

        Index(String name, String col, Boolean nonUnique, String filter) {
            this.name = name;
            this.attrs = new ArrayList<String>();
            this.cols = new ArrayList<String>();
            this.unique = nonUnique == false;
            this.method = null;
            this.filter = filter;
            this.add(this.name, col, this.unique);
        }

        public final SQLTable getTable() {
            return SQLTable.this;
        }

        final void add(String name, String col, boolean unique) {
            if (!name.equals(this.name) || this.unique != unique) {
                throw new IllegalStateException("incoherence");
            }
            this.attrs.add(col);
            if (this.getTable().contains(col)) {
                this.cols.add(col);
            }
        }

        final void add(Index o) {
            this.add(o.getName(), o.cols.get(0), o.unique);
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isUnique() {
            return this.unique;
        }

        public final List<String> getAttrs() {
            return this.attrs;
        }

        public final List<String> getCols() {
            return this.cols;
        }

        final boolean isPKIndex() {
            return this.isUnique() && this.getAttrs().equals(SQLTable.this.getPKsNames());
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName() + " unique: " + this.isUnique() + " cols: " + this.getAttrs();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Index) {
                Index o = (Index)obj;
                return this.isUnique() == o.isUnique() && this.getAttrs().equals(o.getAttrs());
            }
            return false;
        }

        public int hashCode() {
            return this.getAttrs().hashCode() + Boolean.valueOf(this.isUnique()).hashCode();
        }
    }
}

