/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.CollectionChangeEventCreator;

public final class SQLServer
extends DBStructureItemJDBC {
    private final SQLSystem system;
    private final String login;
    private final String pass;
    private final IClosure<DBSystemRoot> systemRootInit;
    private Map<String, SQLBase> bases;
    private String defaultBase;
    private SQLDataSource ds = null;
    private boolean dsSet = false;
    private final IClosure<SQLDataSource> dsInit;
    private final ITransformer<String, String> urlTransf;

    public SQLServer(String system, String host, String port, String login, String pass, IClosure<DBSystemRoot> systemRootInit, IClosure<SQLDataSource> dsInit) {
        super(null, host);
        this.dsInit = dsInit;
        this.system = SQLSystem.get(system);
        this.login = login;
        this.pass = pass;
        this.bases = null;
        this.systemRootInit = systemRootInit;
        this.urlTransf = this.getSQLSystem().getURLTransf(this);
    }

    private final Map<String, SQLBase> getBases() {
        if (this.bases == null) {
            this.bases = new HashMap<String, SQLBase>();
            this.refetch(null, false);
        }
        return this.bases;
    }

    public final void destroy() {
        this.dropped();
    }

    @Override
    protected void onDrop() {
        if (this.ds != null) {
            try {
                this.ds.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.getBases().clear();
        super.onDrop();
    }

    void refetch(Set<String> namesToRefresh) {
        this.refetch(namesToRefresh, true);
    }

    private void refetch(Set<String> namesToRefresh, boolean createBase) {
        if (this.getDS() != null) {
            try {
                Set<String> childrenToRefresh = CollectionUtils.inter(namesToRefresh, this.getChildrenNames());
                List allCats = (List)SQLDataSource.COLUMN_LIST_HANDLER.handle(this.getDS().getConnection().getMetaData().getCatalogs());
                this.getDS().returnConnection();
                Set<String> cats = CollectionUtils.inter(namesToRefresh, new HashSet(allCats));
                this.getDBSystemRoot().filterNodes(this, cats);
                SQLBase.mustContain(this, cats, childrenToRefresh, "bases");
                for (String base : CollectionUtils.substract(childrenToRefresh, cats)) {
                    CollectionChangeEventCreator c = this.createChildrenCreator();
                    SQLBase existingBase = this.getBases().remove(base);
                    this.fireChildrenChanged(c);
                    if (existingBase == null) continue;
                    existingBase.dropped();
                }
                DBFileCache cache = this.getFileCache();
                if (cache != null) {
                    for (DBItemFileCache savedBase : cache.getServerCache().getSavedDesc(SQLBase.class)) {
                        String savedBaseName = savedBase.getName();
                        if (cats.contains(savedBaseName) || namesToRefresh != null && !namesToRefresh.contains(savedBaseName) || !this.getDBSystemRoot().createNode(this, savedBaseName)) continue;
                        savedBase.delete();
                    }
                }
                for (String cat : cats) {
                    if (this.isCreated(cat)) {
                        this.getBase(cat).fetchTables();
                        continue;
                    }
                    if (createBase) {
                        this.getBase(cat);
                        continue;
                    }
                    this.putBase(cat, null);
                }
                if (createBase && this.getDBSystemRoot() != null) {
                    this.getDBSystemRoot().descendantsChanged();
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException("could not get children names", e);
            }
        }
    }

    private final SQLDataSource getDS() {
        if (!this.dsSet) {
            DBSystemRoot sysRoot = this.getDBSystemRoot();
            this.ds = sysRoot == null ? null : sysRoot.getDataSource();
            this.dsSet = true;
        }
        return this.ds;
    }

    final String getURL(String base) {
        return this.urlTransf.transformChecked(base);
    }

    public SQLBase getBase(String baseName) {
        return this.getBase(baseName, null, null);
    }

    public SQLBase getBase(String baseName, String login, String pass) {
        return this.getBase(baseName, login, pass, null);
    }

    public SQLBase getBase(String baseName, String login, String pass, IClosure<SQLDataSource> dsInit) {
        SQLBase base = this.getBases().get(baseName);
        if (base == null) {
            base = this.getSQLSystem().getSyntax().createBase(this, baseName, login == null ? this.login : login, pass == null ? this.pass : pass, dsInit != null ? dsInit : this.dsInit);
            this.putBase(baseName, base);
        }
        return base;
    }

    public final DBSystemRoot getSystemRoot(String name) {
        return this.getSystemRoot(name, null, null, null);
    }

    public final DBSystemRoot getSystemRoot(String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        if (!this.isSystemRootCreated(name)) {
            return this.createSystemRoot(name, login, pass, dsInit);
        }
        DBSystemRoot sysRoot = this.getDBSystemRoot();
        DBSystemRoot res = sysRoot != null ? sysRoot : this.getBase(name).getDBSystemRoot();
        return res;
    }

    private final DBSystemRoot createSystemRoot(String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        DBSystemRoot res;
        DBSystemRoot sysRoot = this.getDBSystemRoot();
        if (sysRoot != null) {
            res = sysRoot;
            res.setDS(login == null ? this.login : login, pass == null ? this.pass : pass, dsInit != null ? dsInit : this.dsInit);
        } else {
            res = this.getBase(name, login, pass, dsInit).getDBSystemRoot();
        }
        return res;
    }

    public final boolean isSystemRootCreated(String name) {
        DBSystemRoot sysRoot = this.getDBSystemRoot();
        if (sysRoot != null) {
            return sysRoot.hasDataSource();
        }
        return this.isCreated(name) && this.getBase(name).getDBSystemRoot().hasDataSource();
    }

    private void putBase(String baseName, SQLBase base) {
        boolean setDef = this.defaultBase == null && base != null;
        CollectionChangeEventCreator c = this.createChildrenCreator();
        this.getBases().put(baseName, base);
        this.fireChildrenChanged(c);
        if (base != null) {
            if (this.getDBSystemRoot() != null) {
                this.getDBSystemRoot().descendantsChanged();
            } else {
                base.getDBSystemRoot().descendantsChanged();
            }
        }
        if (setDef) {
            this.setDefaultBase(baseName);
        }
    }

    @Override
    public SQLIdentifier getChild(String name) {
        return this.getBase(name);
    }

    @Override
    public Set<String> getChildrenNames() {
        return this.getBases().keySet();
    }

    public boolean isCreated(String baseName) {
        return this.getBases().get(baseName) != null;
    }

    public void setDefaultBase(String defaultBase) {
        if (defaultBase != null && !this.contains(defaultBase)) {
            throw new IllegalArgumentException(String.valueOf(defaultBase) + " unknown");
        }
        this.defaultBase = defaultBase;
    }

    public String toString() {
        return this.getName();
    }

    public final SQLSystem getSQLSystem() {
        return this.system;
    }

    void init(DBSystemRoot systemRoot) {
        if (this.systemRootInit != null) {
            this.systemRootInit.executeChecked(systemRoot);
        }
    }

    public final DBFileCache getFileCache() {
        return DBFileCache.create(this);
    }
}

