/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.SQLName;

public abstract class SQLIdentifier
extends DBStructureItemJDBC {
    protected SQLIdentifier(DBStructureItemJDBC parent, String name) {
        super(parent, name);
    }

    public final SQLName getSQLName() {
        return this.getSQLName(null);
    }

    public final SQLName getSQLName(DBStructureItem ancestor) {
        return this.getSQLName(ancestor, true);
    }

    public final SQLName getSQLName(DBStructureItem ancestor, boolean includeAncestor) {
        ArrayList<String> res = new ArrayList<String>();
        SQLIdentifier current = this;
        while (current != null && !current.isAlterEgoOf(ancestor)) {
            res.add(0, current.getName());
            SQLIdentifier sQLIdentifier = current = current.getParent() instanceof SQLIdentifier ? (SQLIdentifier)current.getParent() : null;
        }
        if (current == null && ancestor != null) {
            throw new IllegalArgumentException(ancestor + " is not an ancestor of " + this);
        }
        if (includeAncestor && ancestor != null) {
            res.add(0, ancestor.getName());
        }
        return new SQLName(res);
    }

    public final SQLName getContextualSQLName(SQLIdentifier from) {
        DBStructureItemJDBC common = this.getCommonAncestor(from);
        if (common instanceof SQLIdentifier) {
            return this.getSQLName(common, common == this);
        }
        return this.getSQLName();
    }
}

