/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;

public final class DBFileCache {
    static final StringUtils.Escaper esc = FileUtils.FILENAME_ESCAPER;
    private final SQLServer server;
    private final DBItemFileCache serverCache;

    private static final File getFwkSaveDir() {
        File confDir;
        if (Configuration.getInstance() != null) {
            confDir = Configuration.getInstance().getConfDir();
        } else if (System.getProperty("app.name") != null) {
            confDir = new File(Configuration.getDefaultConfDir(), System.getProperty("app.name"));
        } else {
            return null;
        }
        return new File(confDir, "DBCache/20080904-1411");
    }

    private static final File getValidFwkSaveDir() {
        File fwkDir = DBFileCache.getFwkSaveDir();
        if (fwkDir == null) {
            throw new IllegalStateException("could not find the save dir");
        }
        return fwkDir;
    }

    private static final String getName(SQLSystem sys) {
        return sys.name().toLowerCase();
    }

    public static final List<String> getJDBCAncestorNames(DBStructureItem<?> db, boolean includeServer) {
        DBStructureItemJDBC jdbc = db.getJDBC();
        ArrayList ancs = new ArrayList(jdbc.getAncestors());
        SQLServer server = (SQLServer)ancs.remove(0);
        ArrayList<String> names = new ArrayList<String>(ancs.size() + 2);
        if (includeServer) {
            names.add(DBFileCache.getName(server.getSQLSystem()));
            names.add(server.getName());
        }
        for (DBStructureItemJDBC anc : ancs) {
            names.add(anc.getName());
        }
        return names;
    }

    public static final DBFileCache create(SQLServer s) {
        File d = DBFileCache.getFwkSaveDir();
        if (d == null) {
            return null;
        }
        return new DBFileCache(s);
    }

    DBFileCache(SQLServer s) {
        if (s == null) {
            throw new NullPointerException("null server");
        }
        this.server = s;
        try {
            FileUtils.mkdir_p(this.getSystemDir());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not create dirs", e);
        }
        this.serverCache = this.getChildFrom(this.getSystemDir(), Collections.singletonList(this.server.getName()));
    }

    final File getSystemDir() {
        return new File(DBFileCache.getValidFwkSaveDir(), esc.escape(DBFileCache.getName(this.server.getSQLSystem())));
    }

    public final SQLServer getServer() {
        return this.server;
    }

    public final DBItemFileCache getServerCache() {
        return this.serverCache;
    }

    public final DBItemFileCache getChild(String ... names) {
        return this.getChild(Arrays.asList(names));
    }

    public final DBItemFileCache getChild(List<String> names) {
        return this.getChildFrom(this.getServerCache().getDir(), names);
    }

    private final DBItemFileCache getChildFrom(File dir, List<String> names) {
        return new DBItemFileCache(this, DBItemFileCache.getDescendant(dir, names));
    }

    public final DBItemFileCache getChild(DBStructureItem<?> db) {
        return this.getChild(DBFileCache.getJDBCAncestorNames(db, false));
    }
}

