/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.apache.commons.collections.iterators.EntrySetMapIterator;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.DeletionMode;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowMode;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.RowActionFactory;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.change.ListChangeRecorder;

public abstract class SQLElement {
    private static final Set<String> computingFF = Collections.unmodifiableSet(new HashSet());
    private static final Set<SQLField> computingRF = Collections.unmodifiableSet(new HashSet());
    private final String singular;
    private final String plural;
    private final SQLTable primaryTable;
    private ComboSQLRequest combo;
    private ListSQLRequest list;
    private final ListChangeRecorder<RowAction> rowActions;
    private final List<RowActionFactory> rowActionFactories;
    private Set<String> normalFF;
    private String parentFF;
    private Set<String> sharedFF;
    private Map<String, SQLElement> privateFF;
    private final Map<String, ReferenceAction> actions;
    private Set<SQLField> childRF;
    private Set<SQLField> privateParentRF;
    private Set<SQLField> otherRF;
    private SQLCache<SQLRowAccessor, Object> modelCache;
    private final Map<String, JComponent> additionalFields;

    public SQLElement(String singular, String plural, SQLTable primaryTable) {
        this.singular = singular;
        this.plural = plural;
        if (primaryTable == null) {
            throw new DBStructureItemNotFound("table is null for " + this);
        }
        this.primaryTable = primaryTable;
        this.combo = null;
        this.list = null;
        this.rowActions = new ListChangeRecorder(new ArrayList());
        this.rowActionFactories = new ArrayList<RowActionFactory>();
        this.actions = new HashMap<String, ReferenceAction>();
        this.resetRelationships();
        this.modelCache = null;
        this.additionalFields = new HashMap<String, JComponent>();
    }

    public synchronized void resetRelationships() {
        this.privateFF = null;
        this.parentFF = null;
        this.normalFF = null;
        this.sharedFF = null;
        this.actions.clear();
        this.childRF = null;
        this.privateParentRF = null;
        this.otherRF = null;
    }

    private void checkSelfCall(boolean check, String methodName) {
        assert (check) : this + " " + methodName + "() is calling itself, and thus the caller will only see a partial state";
    }

    private synchronized void initFF() {
        this.checkSelfCall(this.sharedFF != computingFF, "initFF");
        if (this.sharedFF != null) {
            return;
        }
        this.sharedFF = computingFF;
        HashSet<String> privates = new HashSet<String>(this.getPrivateFields());
        this.privateFF = new HashMap<String, SQLElement>(privates.size());
        HashSet<String> parents = new HashSet<String>();
        this.normalFF = new HashSet<String>();
        HashSet<String> tmpSharedFF = new HashSet<String>();
        for (SQLField ff : this.getTable().getForeignKeys()) {
            String fieldName = ff.getName();
            SQLElement foreignElement = this.getForeignElement(fieldName);
            if (privates.contains(fieldName)) {
                privates.remove(fieldName);
                this.privateFF.put(fieldName, foreignElement);
                continue;
            }
            if (foreignElement.isShared()) {
                tmpSharedFF.add(fieldName);
                continue;
            }
            if (foreignElement.getChildrenReferentFields().contains(ff)) {
                parents.add(fieldName);
                continue;
            }
            this.normalFF.add(fieldName);
        }
        if (parents.size() > 1) {
            throw new IllegalStateException("for " + this + " more than one parent :" + parents);
        }
        String string = this.parentFF = parents.size() == 0 ? null : (String)parents.iterator().next();
        if (privates.size() > 0) {
            throw new IllegalStateException("for " + this + " these private foreign fields are not valid :" + privates);
        }
        this.sharedFF = tmpSharedFF;
        this.actions.put(this.parentFF, ReferenceAction.CASCADE);
        for (String s : this.privateFF.keySet()) {
            this.actions.put(s, ReferenceAction.SET_EMPTY);
        }
        for (String s : this.normalFF) {
            this.actions.put(s, ReferenceAction.SET_EMPTY);
        }
        for (String s : this.sharedFF) {
            this.actions.put(s, ReferenceAction.RESTRICT);
        }
        this.ffInited();
    }

    protected void ffInited() {
    }

    private synchronized Set<SQLField> computeChildrenRF() {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (String child : this.getChildren()) {
            SQLField childField;
            int comma = child.indexOf(44);
            String tableName = comma < 0 ? child : child.substring(0, comma);
            SQLTable childTable = this.getTable().getTable(tableName);
            if (comma < 0) {
                Set<SQLField> keys = childTable.getForeignKeys(this.getTable());
                if (keys.size() != 1) {
                    throw new IllegalArgumentException("cannot find a foreign from " + child + " to " + this.getTable());
                }
                childField = keys.iterator().next();
            } else {
                childField = childTable.getField(child.substring(comma + 1));
                SQLTable foreignTable = childField.getDBSystemRoot().getGraph().getForeignTable(childField);
                if (!foreignTable.equals(this.getTable())) {
                    throw new IllegalArgumentException(childField + " doesn't point to " + this.getTable());
                }
            }
            res.add(childField);
        }
        return res;
    }

    private synchronized void initChildRF() {
        this.checkSelfCall(this.childRF != computingRF, "initFF");
        if (this.childRF != null) {
            return;
        }
        this.childRF = computingRF;
        Set<SQLField> children = this.computeChildrenRF();
        HashSet<SQLField> tmpChildRF = new HashSet<SQLField>();
        for (SQLField refField : this.getTable().getBase().getGraph().getReferentKeys(this.getTable())) {
            SQLField refParentFF;
            SQLElement refElem = this.getElementLenient(refField.getTable());
            SQLField sQLField = refParentFF = refElem == null ? null : refElem.getParentFF();
            if (refParentFF != null && children.contains(refField)) {
                throw new IllegalStateException(refElem + " specifies this as its parent: " + refParentFF + " and is also mentioned as our (" + this + ") child: " + refField);
            }
            if (!children.contains(refField) && refParentFF != refField) continue;
            tmpChildRF.add(refField);
        }
        this.childRF = tmpChildRF;
    }

    final SQLElement getElement(SQLTable table) {
        SQLElement res = this.getElementLenient(table);
        if (res == null) {
            throw new IllegalStateException("no element for " + table.getSQLName());
        }
        return res;
    }

    final SQLElement getElementLenient(SQLTable table) {
        return Configuration.getInstance().getDirectory().getElement(table);
    }

    public final SQLElement getForeignElement(String foreignField) {
        try {
            return this.getElement(this.getForeignTable(foreignField));
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("no element for " + foreignField + " in " + this, e);
        }
    }

    private final SQLTable getForeignTable(String foreignField) {
        return this.getTable().getBase().getGraph().getForeignTable(this.getTable().getField(foreignField));
    }

    private Set<SQLRow> getArchivedConnectedRows(Collection<SQLRow> rows) throws SQLException {
        HashSet<SQLRow> res = new HashSet<SQLRow>();
        for (SQLRow row : rows) {
            this.getElement(row.getTable()).getArchivedConnectedRows(row, res);
        }
        return res;
    }

    private void getArchivedConnectedRows(SQLRow row, Set<SQLRow> rows) throws SQLException {
        this.check(row);
        if (!rows.add(row)) {
            return;
        }
        SQLRowMode mode = new SQLRowMode(SQLSelect.ArchiveMode.ARCHIVED, true, true);
        HashSet<SQLRow> foreigns = new HashSet<SQLRow>(this.getNormalForeigns(row, mode).values());
        SQLRow parent = this.getParent(row, mode);
        if (parent != null) {
            foreigns.add(parent);
        }
        for (SQLRow foreign : foreigns) {
            this.getElement(foreign.getTable()).getArchivedConnectedRows(foreign, rows);
        }
    }

    public final void unarchive(int id) throws SQLException {
        this.unarchive(this.getTable().getRow(id));
    }

    public void unarchive(SQLRow row) throws SQLException {
        this.checkUndefined(row);
        List<SQLRow> descsAndMe = this.getTree(row, true);
        final Set<SQLRow> connectedRows = this.getArchivedConnectedRows(descsAndMe);
        SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                for (SQLRow desc : connectedRows) {
                    SQLElement.this.getElement(desc.getTable()).unarchiveSingle(desc);
                }
                for (SQLRow desc : connectedRows) {
                    DeletionMode.UnArchiveMode.fireChange(desc);
                }
                return null;
            }
        });
    }

    public final void archive(int id) throws SQLException {
        this.archive(this.getTable().getRow(id));
    }

    public final void archive(SQLRow row) throws SQLException {
        this.archive(row, true);
    }

    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        this.archive(new TreesOfSQLRows(this, row), cutLinks);
    }

    protected void archive(final TreesOfSQLRows trees, final boolean cutLinks) throws SQLException {
        if (trees.getElem() != this) {
            throw new IllegalArgumentException(this + " != " + trees.getElem());
        }
        for (SQLRow row : trees.getRows()) {
            this.checkUndefined(row);
        }
        SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                if (cutLinks) {
                    CollectionMap<SQLField, SQLRow> externReferences = trees.getExternReferences();
                    if (Log.get().isLoggable(Level.FINEST)) {
                        Log.get().finest("will cut : " + externReferences);
                    }
                    EntrySetMapIterator refIter = new EntrySetMapIterator(externReferences);
                    while (refIter.hasNext()) {
                        SQLField refKey = (SQLField)refIter.next();
                        Collection refList = (Collection)refIter.getValue();
                        for (SQLRow ref : refList) {
                            ref.createEmptyUpdateRow().putEmptyLink(refKey.getName()).update();
                        }
                    }
                    Log.get().finest("done cutting links");
                }
                for (SQLRowAccessor desc : trees.getFlatDescendants()) {
                    SQLElement.this.getElement(desc.getTable()).archiveSingle(desc);
                    DeletionMode.ArchiveMode.fireChange(desc);
                }
                return null;
            }
        });
    }

    private final void archiveSingle(SQLRowAccessor r) throws SQLException {
        this.changeSingle(r, DeletionMode.ArchiveMode);
    }

    private final void unarchiveSingle(SQLRowAccessor r) throws SQLException {
        this.changeSingle(r, DeletionMode.UnArchiveMode);
    }

    private final void changeSingle(SQLRowAccessor r, DeletionMode m) throws SQLException {
        m.execute(this, r);
    }

    public final SQLTable getTable() {
        return this.primaryTable;
    }

    public boolean isShared() {
        return false;
    }

    public boolean dontDeepCopy() {
        return false;
    }

    public final synchronized Set<SQLField> getChildrenReferentFields() {
        this.initChildRF();
        return this.childRF;
    }

    protected Set<String> getChildren() {
        return Collections.emptySet();
    }

    public final synchronized Set<String> getNormalForeignFields() {
        this.initFF();
        return this.normalFF;
    }

    public final synchronized Set<String> getSharedForeignFields() {
        this.initFF();
        return this.sharedFF;
    }

    public final synchronized String getParentForeignField() {
        this.initFF();
        return this.parentFF;
    }

    private final SQLField getParentFF() {
        String name = this.getParentFFName();
        return name == null ? null : this.getTable().getField(name);
    }

    protected String getParentFFName() {
        return null;
    }

    private final synchronized Map<String, SQLElement> getPrivateFF() {
        this.initFF();
        return this.privateFF;
    }

    public final Set<String> getPrivateForeignFields() {
        return Collections.unmodifiableSet(this.getPrivateFF().keySet());
    }

    public final SQLElement getPrivateElement(String foreignField) {
        return this.getPrivateFF().get(foreignField);
    }

    protected List<String> getPrivateFields() {
        return Collections.emptyList();
    }

    final Map<String, ReferenceAction> getActions() {
        this.initFF();
        return this.actions;
    }

    public final void setAction(String ff, ReferenceAction action) throws IllegalArgumentException {
        if (action.compareTo(ReferenceAction.RESTRICT) < 0 && !this.getNormalForeignFields().contains(ff)) {
            throw new IllegalArgumentException(String.valueOf(ff) + " is not normal: " + this.getNormalForeignFields());
        }
        this.getActions().put(ff, action);
    }

    public String getDescription(SQLRow fromRow) {
        return fromRow.toString();
    }

    private <R extends SQLRowAccessor> void forChildrenDo(R row, ChildProcessor<? super R> c, boolean deep, boolean archived) throws SQLException {
        for (SQLField childField : this.getChildrenReferentFields()) {
            if (!deep && this.getElement(childField.getTable()).dontDeepCopy()) continue;
            List<SQLRow> children = row.asRow().getReferentRows(childField, archived ? SQLSelect.ARCHIVED : SQLSelect.UNARCHIVED);
            for (SQLRow child : children) {
                c.process(row, childField, this.convert(child, row));
            }
        }
    }

    private <R extends SQLRowAccessor> R convert(SQLRow toConv, R row) {
        SQLRowAccessor ch;
        if (row instanceof SQLRow) {
            ch = toConv;
        } else if (row instanceof SQLRowValues) {
            ch = toConv.createUpdateRow();
        } else {
            throw new IllegalStateException("SQLRowAccessor is neither SQLRow nor SQLRowValues: " + toConv);
        }
        return (R)ch;
    }

    <R extends SQLRowAccessor> void forDescendantsDo(R row, final ChildProcessor<R> c, final boolean deep, final boolean leavesFirst, final boolean archived) throws SQLException {
        this.check(row);
        this.forChildrenDo(row, new ChildProcessor<R>(){

            @Override
            public void process(R parent, SQLField joint, R child) throws SQLException {
                if (!leavesFirst) {
                    c.process(parent, joint, child);
                }
                SQLElement.this.getElement(((SQLRowAccessor)child).getTable()).forDescendantsDo(child, c, deep, leavesFirst, archived);
                if (leavesFirst) {
                    c.process(parent, joint, child);
                }
            }
        }, deep, archived);
    }

    void check(SQLRowAccessor row) {
        if (!row.getTable().equals(this.getTable())) {
            throw new IllegalArgumentException("row must of table " + this.getTable() + " : " + row);
        }
    }

    private void checkUndefined(SQLRow row) {
        this.check(row);
        if (row.isUndefined()) {
            throw new IllegalArgumentException("row is undefined: " + row);
        }
    }

    private List<SQLRow> getTree(SQLRow row, boolean archived) {
        this.check(row);
        final ArrayList<SQLRow> descsAndMe = new ArrayList<SQLRow>();
        try {
            this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                @Override
                public void process(SQLRow parent, SQLField joint, SQLRow desc) throws SQLException {
                    descsAndMe.add(desc);
                }
            }, true, true, archived);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (row.isArchived() == archived) {
            descsAndMe.add(row);
        }
        return descsAndMe;
    }

    private SQLRow getParent(SQLRow row, SQLRowMode mode) {
        this.check(row);
        return this.getParentForeignField() == null ? null : row.getForeignRow(this.getParentForeignField(), mode);
    }

    private Map<String, SQLRow> getNormalForeigns(SQLRow row, SQLRowMode mode) {
        this.check(row);
        HashMap<String, SQLRow> mm = new HashMap<String, SQLRow>();
        for (String ff : this.getNormalForeignFields()) {
            SQLRow foreignRow = row.getForeignRow(ff, mode);
            if (foreignRow == null) continue;
            mm.put(ff, foreignRow);
        }
        return mm;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SQLElement) {
            SQLElement o = (SQLElement)obj;
            boolean parentEq = CompareUtils.equals(this.getParentForeignField(), o.getParentForeignField());
            return this.getTable().equals(o.getTable()) && this.getSharedForeignFields().equals(o.getSharedForeignFields()) && parentEq && this.getPrivateForeignFields().equals(o.getPrivateForeignFields()) && this.getChildrenReferentFields().equals(o.getChildrenReferentFields());
        }
        return false;
    }

    public final int hashCode() {
        return this.getTable().hashCode() + this.getSharedForeignFields().hashCode() + this.getPrivateForeignFields().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " '" + this.plural + "'";
    }

    static interface ChildProcessor<R extends SQLRowAccessor> {
        public void process(R var1, SQLField var2, R var3) throws SQLException;
    }

    public static enum ReferenceAction {
        SET_EMPTY,
        CASCADE,
        RESTRICT;

    }
}

