/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.LocalPortForwarder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.collections.Predicate;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.cc.IClosure;

public class PropsConfiguration
extends Configuration {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM/dd_EEEE");
    public static final Properties DEFAULTS = new Properties();
    private final Properties props;
    private SQLServer server;
    private DBSystemRoot sysRoot;
    private DBRoot root;
    private ShowAs showAs;
    private SQLFilter filter;
    private SQLFieldTranslator translator;
    private SQLElementDirectory directory;
    private SQLElementDirectory.DirectoryListener directoryListener;
    private File wd;
    private final Object treeLock = new String("treeLock");
    private final Object restLock = new String("everythingElseLock");
    private final List<Configuration> showAsToAdd;
    private final List<Configuration> directoryToAdd;
    private final List<Configuration> translationsToAdd;
    private Connection conn;
    private LocalPortForwarder lpf;
    private boolean isUsingSSH;

    static {
        File wd = new File(System.getProperty("user.dir"));
        DEFAULTS.setProperty("wd", wd.getPath());
        DEFAULTS.setProperty("customer", "test");
        DEFAULTS.setProperty("server.ip", "127.0.0.1");
        DEFAULTS.setProperty("server.login", "root");
    }

    public static String getHostname() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "local";
        }
        return addr.getHostName();
    }

    protected static Properties create(InputStream f, Properties defaults) throws IOException {
        Properties props = new Properties(defaults);
        if (f != null) {
            props.load(f);
            f.close();
        }
        return props;
    }

    public PropsConfiguration() throws IOException {
        this(new File("fwk_SQL.properties"), DEFAULTS);
    }

    public PropsConfiguration(File f, Properties defaults) throws IOException {
        this(new FileInputStream(f), defaults);
    }

    public PropsConfiguration(InputStream f, Properties defaults) throws IOException {
        this(PropsConfiguration.create(f, defaults));
    }

    public PropsConfiguration(Properties props) {
        this.props = props;
        this.showAsToAdd = new ArrayList<Configuration>();
        this.directoryToAdd = new ArrayList<Configuration>();
        this.translationsToAdd = new ArrayList<Configuration>();
        this.setUp();
    }

    public void destroy() {
        this.closeSSLConnection();
        if (this.server != null) {
            this.server.destroy();
        }
        if (this.directoryListener != null) {
            this.directory.removeListener(this.directoryListener);
        }
    }

    public final String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public final String getProperty(String name, String def) {
        return this.props.getProperty(name, def);
    }

    protected final void setProperty(String name, String val) {
        if (val == null) {
            this.props.remove(name);
        } else {
            this.props.setProperty(name, val);
        }
    }

    private void setUp() {
        this.sysRoot = null;
        this.setTranslator(null);
        this.setDirectory(null);
        this.setShowAs(null);
        this.setFilter(null);
    }

    protected final String getSystem() {
        return this.getProperty("server.driver");
    }

    protected String getLogin() {
        return this.getProperty("server.login");
    }

    protected String getPassword() {
        return this.getProperty("server.password");
    }

    public final InputStream getStream(String name) {
        File f = this.getFile(name);
        if (this.mustUseClassloader(f)) {
            return this.getClass().getResourceAsStream(name);
        }
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private File getFile(String name) {
        return new File(name.startsWith("/") ? name.substring(1) : name);
    }

    private boolean mustUseClassloader(File f) {
        return this.getFileMode() == FileMode.IN_JAR || !f.exists();
    }

    public final String getResource(String name) {
        File f = this.getFile(name);
        if (this.mustUseClassloader(f)) {
            return this.getClass().getResource(name).toExternalForm();
        }
        return f.getAbsolutePath();
    }

    protected FileMode getFileMode() {
        return FileMode.IN_JAR;
    }

    protected final DBRoot createRoot() {
        if (this.getRootName() != null) {
            return this.getSystemRoot().getRoot(this.getRootName());
        }
        throw new NullPointerException("no rootname");
    }

    public String getRootName() {
        return this.getProperty("base.root");
    }

    protected SQLServer createServer() {
        RuntimeException origExn;
        Logger log;
        String wanPort;
        String wanAddr;
        block8: {
            wanAddr = this.getProperty("server.wan.addr");
            wanPort = this.getProperty("server.wan.port");
            if (wanAddr == null || wanPort == null) {
                return this.doCreateServer();
            }
            log = Log.get();
            origExn = null;
            if (!"true".equals(this.getProperty("server.wan.only"))) {
                try {
                    SQLServer defaultServer = this.doCreateServer();
                    defaultServer.getSystemRoot(this.getSystemRootName());
                    log.config("using " + defaultServer);
                    return defaultServer;
                }
                catch (RuntimeException e) {
                    origExn = e;
                    log.config(e.getLocalizedMessage());
                    if ($assertionsDisabled || origExn != null) break block8;
                    throw new AssertionError();
                }
            }
        }
        this.conn = new Connection(wanAddr, Integer.valueOf(wanPort).intValue());
        this.openSSLConnection();
        this.isUsingSSH = true;
        log.info("ssl connection to " + this.conn.getHostname() + ":" + this.conn.getPort());
        int localPort = 5436;
        try {
            String[] serverAndPort = this.getProperty("server.ip").split(":");
            log.info("ssl tunnel from local port 5436 to remote " + serverAndPort[0] + ":" + serverAndPort[1]);
            this.lpf = this.conn.createLocalPortForwarder(5436, serverAndPort[0], Integer.valueOf(serverAndPort[1]).intValue());
        }
        catch (IOException e1) {
            throw new IllegalStateException("Impossible de cr\u00e9er la liaison s\u00e9curis\u00e9e. V\u00e9rifier que le logiciel n'est pas d\u00e9j\u00e0 lanc\u00e9.", e1);
        }
        this.setProperty("server.ip", "localhost:5436");
        SQLServer serverThruSSL = this.doCreateServer();
        try {
            serverThruSSL.getSystemRoot(this.getSystemRootName());
        }
        catch (Exception e) {
            this.closeSSLConnection();
            throw new IllegalStateException("Couldn't connect through SSL : " + e.getLocalizedMessage(), origExn);
        }
        return serverThruSSL;
    }

    private SQLServer doCreateServer() {
        return new SQLServer(this.getSystem(), this.getProperty("server.ip"), null, this.getLogin(), this.getPassword(), new IClosure<DBSystemRoot>(){

            @Override
            public void executeChecked(DBSystemRoot input) {
                input.getRootsToMap().addAll(PropsConfiguration.this.getRootsToMap());
            }
        }, new IClosure<SQLDataSource>(){

            @Override
            public void executeChecked(SQLDataSource input) {
                PropsConfiguration.this.initDS(input);
            }
        });
    }

    private void openSSLConnection() {
        String username = this.getSSLUserName();
        boolean isAuthenticated = false;
        try {
            this.conn.connect(null, 6000, 12000);
            ByteArrayOutputStream out = new ByteArrayOutputStream(700);
            String name = String.valueOf(username) + "_dsa";
            InputStream in = this.getClass().getResourceAsStream(name);
            if (in == null) {
                throw new IllegalStateException("Missing private key " + this.getClass().getCanonicalName() + "/" + name);
            }
            StreamUtils.copy(in, out);
            in.close();
            isAuthenticated = this.conn.authenticateWithPublicKey(username, out.toString("UTF-8").toCharArray(), null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Connection failed", e);
        }
        if (!isAuthenticated) {
            throw new IllegalStateException("Authentication failed.");
        }
    }

    public String getSSLUserName() {
        return this.getProperty("server.wan.user");
    }

    private void closeSSLConnection() {
        if (this.lpf != null) {
            try {
                this.lpf.close();
                this.lpf = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    protected Collection<String> getRootsToMap() {
        String rootsToMap;
        HashSet<String> res = new HashSet<String>();
        if (this.getRootName() != null) {
            res.add(this.getRootName());
        }
        if ((rootsToMap = this.getProperty("systemRoot.rootsToMap")) != null) {
            res.addAll(SQLRow.toList(rootsToMap));
        }
        return res;
    }

    public String getSystemRootName() {
        return this.getProperty("systemRoot");
    }

    protected DBSystemRoot createSystemRoot() {
        String rootsPath;
        DBSystemRoot res = this.getServer(false).getSystemRoot(this.getSystemRootName());
        if (res.getChildrenNames().contains(this.getRootName())) {
            res.setDefaultRoot(this.getRootName());
        }
        if ((rootsPath = this.getProperty("systemRoot.rootPath")) != null) {
            for (String root : SQLRow.toList(rootsPath)) {
                if (!res.getChildrenNames().contains(root)) continue;
                res.appendToRootPath(root);
            }
        }
        return res;
    }

    protected void initDS(final SQLDataSource ds) {
        ds.setCacheEnabled(true);
        this.propIterate(new IClosure<String>(){

            @Override
            public void executeChecked(String propName) {
                String jdbcName = propName.substring("jdbc.connection.".length());
                ds.addConnectionProperty(jdbcName, PropsConfiguration.this.getProperty(propName));
            }
        }, "jdbc.connection.");
    }

    public final void propIterate(IClosure<String> cl, final String startsWith) {
        this.propIterate(cl, new Predicate(){

            @Override
            public boolean evaluate(Object propName) {
                return ((String)propName).startsWith(startsWith);
            }
        });
    }

    public final void propIterate(IClosure<String> cl, Predicate filter) {
        Enumeration<?> iter = this.props.propertyNames();
        while (iter.hasMoreElements()) {
            String propName = (String)iter.nextElement();
            if (!filter.evaluate(propName)) continue;
            cl.executeChecked(propName);
        }
    }

    public final void setLoggersLevel() {
        this.propIterate(new IClosure<String>(){

            @Override
            public void executeChecked(String propName) {
                String logName = propName.substring("log.level.".length());
                LogUtils.getLogger(logName).setLevel(Level.parse(PropsConfiguration.this.getProperty(propName)));
            }
        }, "log.level.");
    }

    public void setupLogging() {
        this.setupLogging("logs");
    }

    public void setupLogging(String dirName) {
        this.setupLogging(dirName, Boolean.getBoolean("redirectToFile"));
    }

    public void setupLogging(String dirName, boolean redirectToFile) {
        File logFile;
        File logDir;
        try {
            File softLogDir = new File(this.getWD() + "/" + dirName + "/" + PropsConfiguration.getHostname() + "-" + System.getProperty("user.name"));
            softLogDir.mkdirs();
            if (softLogDir.canWrite()) {
                logDir = softLogDir;
            } else {
                File homeLogDir = new File(String.valueOf(System.getProperty("user.home")) + "/." + this.getAppName() + "/" + dirName);
                FileUtils.mkdir_p(homeLogDir);
                logDir = homeLogDir;
            }
            System.out.println("Log directory: " + logDir.getAbsolutePath());
            if (!logDir.exists()) {
                System.err.println("Log directory: " + logDir.getAbsolutePath() + " DOEST NOT EXISTS!!!");
            }
            if (!logDir.canWrite()) {
                System.err.println("Log directory: " + logDir.getAbsolutePath() + " is NOT WRITABLE");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to create log dir", e);
        }
        String logNameBase = String.valueOf(this.getAppName()) + "_" + DATE_FORMAT.format(new Date());
        if (redirectToFile) {
            logFile = new File(logDir, String.valueOf(logNameBase) + ".txt");
            logFile.getParentFile().mkdirs();
            try {
                System.out.println("Log file: " + logFile.getAbsolutePath());
                PrintStream ps = new PrintStream(new FileOutputStream(logFile, true));
                System.setErr(ps);
                System.setOut(ps);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("unable to write to log file", e);
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileUtils.ln(logFile, new File(logDir, "last.log"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        } else {
            System.out.println("Log not redirected to file");
        }
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        try {
            logFile = new File(logDir, String.valueOf(this.getAppName()) + "-%u-age%g.log");
            logFile.getParentFile().mkdirs();
            System.out.println("Logger logs: " + logFile.getAbsolutePath());
            FileHandler fh = new FileHandler(logFile.getPath(), 0x500000, 2, true);
            fh.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(fh);
        }
        catch (IOException e) {
            ExceptionHandler.handle("Enregistrement du Logger d\u00e9sactiv\u00e9", e);
        }
        this.setLoggersLevel();
    }

    public void tearDownLogging(boolean redirectToFile) {
        LogUtils.rmRootHandlers();
        if (redirectToFile) {
            System.out.close();
            System.err.close();
        }
    }

    protected SQLElementDirectory createDirectory() {
        return new SQLElementDirectory();
    }

    protected List<String> getMappings() {
        return Arrays.asList("mapping.xml", "mapping-" + this.getProperty("customer") + ".xml");
    }

    protected SQLFieldTranslator createTranslator() {
        List<String> mappings = this.getMappings();
        if (mappings.size() == 0) {
            throw new IllegalStateException("empty mappings");
        }
        SQLFieldTranslator trns = new SQLFieldTranslator(this.getRoot(), PropsConfiguration.class.getResourceAsStream("mapping.xml"), this.getDirectory());
        for (String m : mappings) {
            InputStream in = this.getStream(m);
            if (in == null) continue;
            trns.load(this.getRoot(), in);
        }
        return trns;
    }

    protected File createWD() {
        return new File(this.getProperty("wd"));
    }

    @Override
    public final SQLBase getBase() {
        return this.getNode(SQLBase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DBRoot getRoot() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.root == null) {
                this.setRoot(this.createRoot());
            }
        }
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBSystemRoot getSystemRoot() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.sysRoot == null) {
                this.sysRoot = this.createSystemRoot();
            }
        }
        return this.sysRoot;
    }

    public final <T extends DBStructureItem> T getNode(Class<T> clazz) {
        SQLSystem sys = this.getServer().getSQLSystem();
        HierarchyLevel l = sys.getLevel(clazz);
        if (l == HierarchyLevel.SQLSERVER) {
            return this.getServer().getAnc(clazz);
        }
        if (l == sys.getLevel(DBSystemRoot.class)) {
            return this.getSystemRoot().getAnc(clazz);
        }
        if (l == sys.getLevel(DBRoot.class)) {
            return this.getRoot().getAnc(clazz);
        }
        throw new IllegalArgumentException("doesn't know an item of " + clazz);
    }

    public final SQLServer getServer() {
        return this.getServer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLServer getServer(boolean initSysRoot) {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.server == null) {
                this.setServer(this.createServer());
                if (initSysRoot && this.server.getSQLSystem().getLevel(DBSystemRoot.class) == HierarchyLevel.SQLSERVER) {
                    this.getSystemRoot();
                }
            }
        }
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SQLFieldTranslator getTranslator() {
        Object object = this.restLock;
        synchronized (object) {
            if (this.translator == null) {
                this.setTranslator(this.createTranslator());
                for (Configuration s : this.translationsToAdd) {
                    this.getTranslator().putAll(s.getTranslator());
                }
                this.translationsToAdd.clear();
            }
        }
        return this.translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SQLElementDirectory getDirectory() {
        Object object = this.restLock;
        synchronized (object) {
            if (this.directory == null) {
                this.setDirectory(this.createDirectory());
                for (Configuration s : this.directoryToAdd) {
                    this.getDirectory().putAll(s.getDirectory());
                }
                this.directoryToAdd.clear();
            }
        }
        return this.directory;
    }

    @Override
    public String getAppName() {
        return this.getProperty("app.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File getWD() {
        Object object = this.restLock;
        synchronized (object) {
            if (this.wd == null) {
                this.setWD(this.createWD());
            }
        }
        return this.wd;
    }

    private final void setFilter(SQLFilter filter) {
        this.filter = filter;
    }

    private void setServer(SQLServer server) {
        this.server = server;
    }

    private final void setRoot(DBRoot root) {
        this.root = root;
    }

    private final void setShowAs(ShowAs showAs) {
        this.showAs = showAs;
    }

    private final void setTranslator(SQLFieldTranslator translator) {
        this.translator = translator;
    }

    private final void setDirectory(SQLElementDirectory directory) {
        this.directory = directory;
    }

    private final void setWD(File dir) {
        this.wd = dir;
    }

    protected static enum FileMode {
        IN_JAR,
        NORMAL_FILE;

    }
}

