/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;

public class Caisse {
    private static Document document;
    private static SQLRow rowClient;

    static {
        rowClient = null;
    }

    public static File getConfigFile(String appName, File wd) {
        File confFile;
        File wdFile = new File(wd + "/Configuration", "pos.xml");
        if (wdFile.isFile()) {
            confFile = wdFile;
        } else {
            File preferencesFolder = DesktopEnvironment.getDE().getPreferencesFolder(appName);
            if (!preferencesFolder.exists()) {
                preferencesFolder.mkdir();
            }
            confFile = new File(preferencesFolder, "pos.xml");
        }
        return confFile;
    }

    private static Document getDocument() {
        if (document != null) {
            return document;
        }
        SAXBuilder constructeur = new SAXBuilder();
        File file = Caisse.getConfigFile();
        document = new Document();
        if (!file.exists()) {
            System.err.println("Erreur le fichier " + file.getAbsolutePath() + " n'existe pas!");
            document.setRootElement(new Element("config"));
            return document;
        }
        try {
            System.out.println("Loading:" + file.getAbsolutePath());
            document = constructeur.build(file);
        }
        catch (Exception e) {
            document.setRootElement(new Element("config"));
        }
        return document;
    }

    private static File getConfigFile() {
        return Caisse.getConfigFile("OpenConcerto", new File("."));
    }

    public static int getID() {
        Document d = Caisse.getDocument();
        return Integer.valueOf(d.getRootElement().getAttributeValue("caisseID", "2"));
    }

    public static void setID(int caisseId) {
        Document d = Caisse.getDocument();
        d.getRootElement().setAttribute("caisseID", String.valueOf(caisseId));
    }

    public static int getUserID() {
        Document d = Caisse.getDocument();
        return Integer.valueOf(d.getRootElement().getAttributeValue("userID", "2"));
    }

    public static void setUserID(int userId) {
        Document d = Caisse.getDocument();
        d.getRootElement().setAttribute("userID", String.valueOf(userId));
    }

    public static int getSocieteID() {
        Document d = Caisse.getDocument();
        return Integer.valueOf(d.getRootElement().getAttributeValue("societeID", "42"));
    }

    public static void setSocieteID(int societeId) {
        Document d = Caisse.getDocument();
        d.getRootElement().setAttribute("societeID", String.valueOf(societeId));
    }

    public static boolean isCopyActive() {
        Document d = Caisse.getDocument();
        return Boolean.valueOf(d.getRootElement().getAttributeValue("copyTicket", "true"));
    }

    public static void setCopyActive(boolean b) {
        Document d = Caisse.getDocument();
        d.getRootElement().setAttribute("copyTicket", b ? "true" : "false");
    }

    public static boolean isUsingJPos() {
        Document d = Caisse.getDocument();
        Element child = d.getRootElement().getChild("printer");
        if (child == null) {
            child = new Element("printer");
            d.getRootElement().addContent(child);
            return false;
        }
        String type = child.getAttributeValue("type");
        return type != null && type.equalsIgnoreCase("jpos");
    }

    public static void setPrinterType(String type) {
        Document d = Caisse.getDocument();
        Element e = d.getRootElement().getChild("printer");
        if (e == null) {
            e = new Element("printer");
            d.getRootElement().addContent(e);
        }
        e.setAttribute("type", type);
    }

    public static String getJPosPrinter() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("jpos");
        if (children != null) {
            for (Element e : children) {
                if (e.getAttribute("printer") == null) continue;
                return e.getAttributeValue("printer");
            }
        }
        return "";
    }

    public static void setJPosPrinter(String printer) {
        Document d = Caisse.getDocument();
        Element e = d.getRootElement().getChild("jpos");
        if (e == null) {
            e = new Element("jpos");
            d.getRootElement().addContent(e);
        }
        e.setAttribute("printer", printer);
    }

    public static String getESCPPort() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("escp");
        if (children != null) {
            for (Element e : children) {
                if (e.getAttribute("port") == null) continue;
                return e.getAttributeValue("port", "COM1:");
            }
        }
        return "COM1:";
    }

    public static void setESCPPort(String port) {
        Document d = Caisse.getDocument();
        Element e = d.getRootElement().getChild("escp");
        if (e == null) {
            e = new Element("escp");
            d.getRootElement().addContent(e);
        }
        e.setAttribute("port", port);
    }

    public static String getJPosDirectory() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("jpos");
        if (children != null) {
            for (Element e : children) {
                if (e.getValue() == null) continue;
                return e.getValue();
            }
        }
        return "";
    }

    public static void setJPosDirectory(String dir) {
        Document d = Caisse.getDocument();
        Element e = d.getRootElement().getChild("jpos");
        if (e == null) {
            e = new Element("jpos");
            d.getRootElement().addContent(e);
        }
        e.setText(dir);
    }

    public static List<TicketLine> getHeaders() {
        ArrayList<TicketLine> l = new ArrayList<TicketLine>();
        Document d = Caisse.getDocument();
        List list = d.getRootElement().getChildren("header");
        if (list != null) {
            for (Element element : list) {
                l.add(new TicketLine(element.getValue(), element.getAttributeValue("style")));
            }
        }
        return l;
    }

    public static void setLines(String type, List<TicketLine> lines) {
        Document d = Caisse.getDocument();
        Element rootElement = d.getRootElement();
        rootElement.removeChildren(type);
        for (TicketLine ticketLine : lines) {
            Element e = new Element(type);
            String style = ticketLine.getStyle();
            if (style != null && !style.isEmpty()) {
                e.setAttribute("style", style);
            }
            e.setText(ticketLine.getText());
            rootElement.addContent(e);
        }
    }

    public static List<TicketLine> getFooters() {
        ArrayList<TicketLine> l = new ArrayList<TicketLine>();
        Document d = Caisse.getDocument();
        List list = d.getRootElement().getChildren("footer");
        if (list != null) {
            for (Element element : list) {
                l.add(new TicketLine(element.getValue(), element.getAttributeValue("style")));
            }
        }
        return l;
    }

    public static void setHeaders(List<TicketLine> lines) {
        Caisse.setLines("header", lines);
    }

    public static void setFooters(List<TicketLine> lines) {
        Caisse.setLines("footer", lines);
    }

    public static int getTicketWidth() {
        Document d = Caisse.getDocument();
        List children = d.getRootElement().getChildren("printer");
        if (children != null) {
            for (Element e : children) {
                if (e.getAttribute("printWidth") == null) continue;
                String attributeValue = e.getAttributeValue("printWidth");
                return Integer.parseInt(attributeValue);
            }
        }
        return 20;
    }

    public static void setTicketWidth(String w) {
        Document d = Caisse.getDocument();
        Element e = d.getRootElement().getChild("printer");
        if (e == null) {
            e = new Element("printer");
            d.getRootElement().addContent(e);
        }
        e.setAttribute("printWidth", w);
    }

    public static void saveConfiguration() {
        File file = Caisse.getConfigFile();
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            System.out.println("Saving:" + file.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            outputter.output(Caisse.getDocument(), (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handle("Erreur lors de la sauvegarde de la configuration de la caisse.\n" + file.getAbsolutePath());
        }
    }
}

