/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.sql.changer.convert.AddFK;
import org.openconcerto.sql.changer.correct.CorrectOrder;
import org.openconcerto.sql.changer.correct.FixSerial;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.DropTable;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;

public class InstallationPanel
extends JPanel {
    JProgressBar bar = new JProgressBar();
    boolean error;

    private static void insertUndef(SQLCreateTable ct) {
        String insert = "INSERT into " + InstallationPanel.getTableName(ct).quote() + "(" + SQLBase.quoteIdentifier("ORDRE") + ") VALUES(" + ReOrder.MIN_ORDER + ")";
        ct.getRoot().getDBSystemRoot().getDataSource().execute(insert);
    }

    private static SQLName getTableName(SQLCreateTable ct) {
        return new SQLName(ct.getRoot().getName(), ct.getName());
    }

    public InstallationPanel(final ServerFinderPanel finderPanel) {
        super(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JButton user = new JButton("Cr\u00e9er l'utilisateur");
        final JButton up = new JButton("Mise \u00e0 niveau de la base");
        up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                finderPanel.saveConfigFile();
                InstallationPanel.this.bar.setIndeterminate(true);
                up.setEnabled(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        final ComptaPropsConfiguration conf = ComptaPropsConfiguration.create(true);
                        try {
                            final SQLDataSource ds = conf.getSystemRoot().getDataSource();
                            System.err.println("SystemRoot:" + conf.getSystemRoot());
                            System.err.println("Root:" + conf.getRoot());
                            final SQLTable table = conf.getRoot().getTable("VARIABLE_PAYE");
                            System.out.println("InstallationPanel.InstallationPanel() UPDATE PAYE");
                            InstallationPanel.this.updateVariablePaye(table, "SMIC", 9.0);
                            InstallationPanel.this.updateVariablePaye(table, "TRANCHE_A", 2946.0);
                            InstallationPanel.this.updateVariablePaye(table, "PART_SAL_GarantieMP", 23.83);
                            InstallationPanel.this.updateVariablePaye(table, "PART_PAT_GarantieMP", 38.98);
                            if (!table.getDBRoot().contains("DEVISE")) {
                                System.out.println("InstallationPanel.InstallationPanel() ADD DEVISE");
                                try {
                                    SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                                        @Override
                                        public Object create() throws SQLException {
                                            SQLCreateTable createDevise = new SQLCreateTable(table.getDBRoot(), "DEVISE");
                                            createDevise.addVarCharColumn("CODE", 128);
                                            createDevise.addVarCharColumn("NOM", 128);
                                            createDevise.addVarCharColumn("LIBELLE", 128);
                                            createDevise.addVarCharColumn("LIBELLE_CENT", 128);
                                            createDevise.addColumn("TAUX", "numeric(16,8) default 1");
                                            ds.execute(createDevise.asString());
                                            InstallationPanel.insertUndef(createDevise);
                                            conf.getRoot().getSchema().updateVersion();
                                            return null;
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DEVISE", ex);
                                }
                            }
                            conf.getSystemRoot().getRootsToMap().clear();
                            conf.getSystemRoot().refetch();
                            final Set<String> childrenNames = conf.getSystemRoot().getChildrenNames();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).InstallationPanel.this.bar.setIndeterminate(false);
                                    ((this).this).InstallationPanel.this.bar.setMaximum(childrenNames.size() + 1);
                                }
                            });
                            int i = 1;
                            for (String childName : childrenNames) {
                                System.out.println("InstallationPanel.InstallationPanel() UPDATE SCHEMA " + childName);
                                final int barValue = i++;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((this).this).InstallationPanel.this.bar.setValue(barValue);
                                    }
                                });
                                final DBRoot root = conf.getSystemRoot().getRoot(childName);
                                SQLTable tableUndef = root.getTable("FWK_UNDEFINED_IDS");
                                if (tableUndef != null && tableUndef.getField("UNDEFINED_ID").isNullable() == Boolean.FALSE) {
                                    AlterTable alterUndef = new AlterTable(tableUndef);
                                    alterUndef.alterColumn("TABLENAME", EnumSet.allOf(SQLField.Properties.class), "varchar(250)", "''", false);
                                    alterUndef.alterColumn("UNDEFINED_ID", EnumSet.allOf(SQLField.Properties.class), "int", null, true);
                                    try {
                                        ds.execute(alterUndef.asString());
                                        tableUndef.getSchema().updateVersion();
                                    }
                                    catch (SQLException ex) {
                                        throw new IllegalStateException("Erreur lors de la modification de UNDEFINED_ID", ex);
                                    }
                                }
                                if (!childName.startsWith(conf.getAppName()) && !childName.equalsIgnoreCase("Default")) continue;
                                SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                                    @Override
                                    public Object create() throws SQLException {
                                        InstallationPanel.this.updateSocieteSchema(root);
                                        InstallationPanel.this.updateToV1Dot2(root);
                                        return null;
                                    }
                                });
                            }
                            (this).InstallationPanel.this.error = false;
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle("Echec de mise \u00e0 jour", e1);
                            (this).InstallationPanel.this.error = true;
                        }
                        conf.destroy();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                up.setEnabled(true);
                                if (!((this).this).InstallationPanel.this.error) {
                                    JOptionPane.showMessageDialog(InstallationPanel.this, "Mise \u00e0 niveau r\u00e9ussie");
                                }
                            }
                        });
                    }
                }, "Database structure updater").start();
            }
        });
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)new JLabelBold("Cr\u00e9ation de l'utilisateur openconcerto dans la base"), c);
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)new JLabel("Identifiant de connexion de votre base "), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Login"), c);
        ++c.gridx;
        final JTextField login = new JTextField();
        c.weightx = 1.0;
        this.add((Component)login, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Mot de passe"), c);
        ++c.gridx;
        final JTextField mdp = new JTextField();
        c.weightx = 1.0;
        this.add((Component)mdp, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.anchor = 13;
        c.gridwidth = 0;
        c.fill = 0;
        this.add((Component)user, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 1;
        user.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (finderPanel.getServerConfig().createUserIfNeeded(login.getText(), mdp.getText())) {
                        JOptionPane.showMessageDialog(InstallationPanel.this, "L'utilisateur openconcerto a \u00e9t\u00e9 correctement ajout\u00e9.");
                    } else {
                        JOptionPane.showMessageDialog(InstallationPanel.this, "L'utilisateur openconcerto existe d\u00e9j\u00e0 dans la base.");
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(InstallationPanel.this, "Une erreur est survenue pendant la connexion au serveur, v\u00e9rifiez vos param\u00e8tres de connexion.");
                }
            }
        });
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(10, 3, 2, 2);
        this.add((Component)new JLabelBold("Mise \u00e0 niveau de la base OpenConcerto"), c);
        ++c.gridy;
        this.add((Component)this.bar, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.anchor = 13;
        c.gridwidth = 0;
        c.fill = 0;
        c.insets = DefaultGridBagConstraints.getDefaultInsets();
        this.add((Component)up, c);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.weighty = 1.0;
        ++c.gridy;
        JPanel comp = new JPanel();
        comp.setOpaque(false);
        this.add((Component)comp, c);
    }

    private void updateToV1Dot2(DBRoot root) throws SQLException {
        SQLCreateTable createTarif;
        AlterTable t;
        SQLTable tableDevis = root.getTable("DEVIS");
        SQLDataSource ds = root.getDBSystemRoot().getDataSource();
        if (!tableDevis.getFieldsName().contains("DATE_VALIDITE")) {
            t = new AlterTable(tableDevis);
            t.addColumn("DATE_VALIDITE", "date");
            try {
                ds.execute(t.asString());
                tableDevis.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout du champ DATE_VALIDITE \u00e0 la table DEVIS", ex);
            }
        }
        t = new AlterTable(tableDevis);
        t.alterColumn("DATE_VALIDITE", EnumSet.allOf(SQLField.Properties.class), "date", null, true);
        try {
            ds.execute(t.asString());
            tableDevis.getSchema().updateVersion();
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Erreur lors de l'ajout du champ DATE_VALIDITE \u00e0 la table DEVIS", ex);
        }
        SQLTable tableBL = root.getTable("BON_DE_LIVRAISON");
        boolean alterBL = false;
        AlterTable t2 = new AlterTable(tableBL);
        if (!tableBL.getFieldsName().contains("SOURCE")) {
            t2.addVarCharColumn("SOURCE", 512);
            alterBL = true;
        }
        if (!tableBL.getFieldsName().contains("IDSOURCE")) {
            t2.addColumn("IDSOURCE", "integer DEFAULT 1");
            alterBL = true;
        }
        if (alterBL) {
            try {
                ds.execute(t2.asString());
                tableBL.getSchema().updateVersion();
                tableBL.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table BON_DE_LIVRAISON", ex);
            }
        }
        SQLTable tableArticle = root.getTable("ARTICLE");
        AlterTable t3 = new AlterTable(tableArticle);
        boolean alterArticle = false;
        if (!tableArticle.getFieldsName().contains("QTE_ACHAT")) {
            t3.addColumn("QTE_ACHAT", "integer DEFAULT 1");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("DESCRIPTIF")) {
            t3.addVarCharColumn("DESCRIPTIF", 2048);
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("CODE_BARRE")) {
            t3.addVarCharColumn("CODE_BARRE", 256);
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("GESTION_STOCK")) {
            t3.addColumn("GESTION_STOCK", "boolean DEFAULT true");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("CODE_DOUANIER")) {
            t3.addVarCharColumn("CODE_DOUANIER", 256);
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("QTE_MIN")) {
            t3.addColumn("QTE_MIN", "integer DEFAULT 1");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_DEVISE")) {
            t3.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_FOURNISSEUR")) {
            t3.addForeignColumn("ID_FOURNISSEUR", root.findTable("FOURNISSEUR"));
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("PV_U_DEVISE")) {
            t3.addColumn("PV_U_DEVISE", "bigint default 0");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_DEVISE_HA")) {
            t3.addForeignColumn("ID_DEVISE_HA", root.findTable("DEVISE"));
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("PA_DEVISE")) {
            t3.addColumn("PA_DEVISE", "bigint default 0");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_PAYS")) {
            t3.addForeignColumn("ID_PAYS", root.findTable("PAYS"));
            alterArticle = true;
        }
        if (alterArticle) {
            try {
                ds.execute(t3.asString());
                tableArticle.getSchema().updateVersion();
                tableArticle.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table ARTICLE", ex);
            }
        }
        boolean refetchRoot = false;
        if (!root.contains("LANGUE")) {
            SQLCreateTable createLangue = new SQLCreateTable(root, "LANGUE");
            createLangue.addVarCharColumn("CODE", 256);
            createLangue.addVarCharColumn("NOM", 256);
            createLangue.addVarCharColumn("CHEMIN", 256);
            try {
                ds.execute(createLangue.asString());
                InstallationPanel.insertUndef(createLangue);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table LANGUE", ex);
            }
            String[] langs = new String[]{"FR", "Fran\u00e7ais", "EN", "Anglais", "SP", "Espagnol", "DE", "Allemand", "NL", "N\u00e9erlandais", "IT", "Italien"};
            ArrayList<String> values = new ArrayList<String>();
            SQLBase base = root.getBase();
            int i = 0;
            while (i < langs.length) {
                int order = values.size() + 1;
                values.add("(" + base.quoteString(langs[i]) + ", " + base.quoteString(langs[i + 1]) + ", " + order + ")");
                i += 2;
            }
            String valuesStr = CollectionUtils.join(values, ", ");
            String insertVals = "INSERT INTO " + InstallationPanel.getTableName(createLangue).quote() + "(" + SQLBase.quoteIdentifier("CODE") + ", " + SQLBase.quoteIdentifier("NOM") + ", " + SQLBase.quoteIdentifier("ORDRE") + ") VALUES" + valuesStr;
            ds.execute(insertVals);
        }
        if (!root.contains("TARIF")) {
            createTarif = new SQLCreateTable(root, "TARIF");
            createTarif.addVarCharColumn("NOM", 256);
            createTarif.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            createTarif.addForeignColumn("ID_TAXE", root.findTable("TAXE"));
            createTarif.asString();
            try {
                ds.execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TARIF", ex);
            }
        }
        if (refetchRoot) {
            root.refetch();
        }
        if (!root.contains("ARTICLE_TARIF")) {
            createTarif = new SQLCreateTable(root, "ARTICLE_TARIF");
            createTarif.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            createTarif.addForeignColumn("ID_TAXE", root.findTable("TAXE"));
            createTarif.addForeignColumn("ID_TARIF", root.findTable("TARIF"));
            createTarif.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE"));
            createTarif.addColumn("PV_HT", "bigint DEFAULT 0");
            createTarif.addColumn("PV_TTC", "bigint DEFAULT 0");
            createTarif.addColumn("PRIX_METRIQUE_VT_1", "bigint DEFAULT 0");
            createTarif.addColumn("PRIX_METRIQUE_VT_2", "bigint DEFAULT 0");
            createTarif.addColumn("PRIX_METRIQUE_VT_3", "bigint DEFAULT 0");
            createTarif.asString();
            try {
                ds.execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                tableDevis.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARTICLE_TARIF", ex);
            }
        }
        if (!root.contains("ARTICLE_DESIGNATION")) {
            createTarif = new SQLCreateTable(root, "ARTICLE_DESIGNATION");
            createTarif.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE"));
            createTarif.addForeignColumn("ID_LANGUE", root.findTable("LANGUE"));
            createTarif.addVarCharColumn("NOM", 1024);
            createTarif.asString();
            try {
                ds.execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                tableDevis.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARTICLE_DESIGNATION", ex);
            }
        }
        SQLTable tableVFElt = root.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        this.addTarifField(tableVFElt, root);
        SQLTable tableDevisElt = root.getTable("DEVIS_ELEMENT");
        this.addTarifField(tableDevisElt, root);
        SQLTable tableCmdElt = root.getTable("COMMANDE_CLIENT_ELEMENT");
        this.addTarifField(tableCmdElt, root);
        SQLTable tableBonElt = root.getTable("BON_DE_LIVRAISON_ELEMENT");
        this.addTarifField(tableBonElt, root);
        SQLTable tableAvoirElt = root.getTable("AVOIR_CLIENT_ELEMENT");
        this.addTarifField(tableAvoirElt, root);
        SQLTable tableCmdFournElt = root.getTable("COMMANDE_ELEMENT");
        this.addTotalDeviseHAField(tableCmdFournElt, root);
        SQLTable tableBonRecptElt = root.getTable("BON_RECEPTION_ELEMENT");
        this.addTotalDeviseHAField(tableBonRecptElt, root);
        SQLTable tableBonRecpt = root.getTable("BON_RECEPTION");
        this.addDeviseHAField(tableBonRecpt, root);
        SQLTable tableCommande = root.getTable("COMMANDE");
        this.addDeviseHAField(tableCommande, root);
        SQLTable tableVF = root.getTable("SAISIE_VENTE_FACTURE");
        this.addTotalDeviseField(tableVF, root);
        this.addTotalDeviseField(tableDevis, root);
        SQLTable tableCmd = root.getTable("COMMANDE_CLIENT");
        this.addTotalDeviseField(tableCmd, root);
        SQLTable tableBon = root.getTable("BON_DE_LIVRAISON");
        this.addTotalDeviseField(tableBon, root);
        SQLTable tableAvoir = root.getTable("AVOIR_CLIENT");
        this.addTotalDeviseField(tableAvoir, root);
        SQLTable tableClient = root.getTable("CLIENT");
        AlterTable tClient = new AlterTable(tableClient);
        boolean alterClient = false;
        if (!tableClient.getFieldsName().contains("ID_TARIF")) {
            tClient.addForeignColumn("ID_TARIF", root.findTable("TARIF"));
            alterClient = true;
        }
        if (!tableClient.getFieldsName().contains("ID_PAYS")) {
            tClient.addForeignColumn("ID_PAYS", root.findTable("PAYS"));
            alterClient = true;
        }
        if (!tableClient.getFieldsName().contains("ID_LANGUE")) {
            tClient.addForeignColumn("ID_LANGUE", root.findTable("LANGUE"));
            alterClient = true;
        }
        if (!tableClient.getFieldsName().contains("ID_DEVISE")) {
            tClient.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            alterClient = true;
        }
        if (alterClient) {
            try {
                ds.execute(tClient.asString());
                tableClient.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table CLIENT", ex);
            }
        }
        SQLTable tablePays = root.getTable("PAYS");
        AlterTable tPays = new AlterTable(tablePays);
        boolean alterPays = false;
        if (!tablePays.getFieldsName().contains("ID_TARIF")) {
            tPays.addForeignColumn("ID_TARIF", root.findTable("TARIF"));
            alterPays = true;
        }
        if (!tablePays.getFieldsName().contains("ID_LANGUE")) {
            tPays.addForeignColumn("ID_LANGUE", root.findTable("LANGUE"));
            alterPays = true;
        }
        if (alterPays) {
            try {
                ds.execute(tPays.asString());
                tablePays.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table PAYS", ex);
            }
        }
        SQLTable tableCmd2 = root.getTable("COMMANDE");
        AlterTable tCmd = new AlterTable(tableCmd2);
        boolean alterCmd = false;
        if (!tableCmd2.getFieldsName().contains("EN_COURS")) {
            tCmd.addColumn("EN_COURS", "boolean default true");
            alterCmd = true;
        }
        if (alterCmd) {
            try {
                ds.execute(tCmd.asString());
                tableCmd2.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table COMMANDE", ex);
            }
        }
        SQLTable tableFournisseur = root.getTable("FOURNISSEUR");
        AlterTable tFourn = new AlterTable(tableFournisseur);
        boolean alterFourn = false;
        if (!tableFournisseur.getFieldsName().contains("ID_LANGUE")) {
            tFourn.addForeignColumn("ID_LANGUE", root.findTable("LANGUE"));
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("ID_DEVISE")) {
            tFourn.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("RESPONSABLE")) {
            tFourn.addVarCharColumn("RESPONSABLE", 256);
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("TEL_P")) {
            tFourn.addVarCharColumn("TEL_P", 256);
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("MAIL")) {
            tFourn.addVarCharColumn("MAIL", 256);
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("INFOS")) {
            tFourn.addVarCharColumn("INFOS", 2048);
            alterFourn = true;
        }
        if (alterFourn) {
            try {
                ds.execute(tFourn.asString());
                tableFournisseur.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table FOURNISSEUR", ex);
            }
        }
        root.refetch();
    }

    private void addDeviseHAField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            alter = true;
        }
        if (!table.getFieldsName().contains("T_DEVISE")) {
            t.addColumn("T_DEVISE", "bigint default 0");
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addTotalDeviseHAField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("QTE_ACHAT")) {
            t.addColumn("QTE_ACHAT", "integer DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("PA_DEVISE")) {
            t.addColumn("PA_DEVISE", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            alter = true;
        }
        if (!table.getFieldsName().contains("PA_DEVISE_T")) {
            t.addColumn("PA_DEVISE_T", "bigint default 0");
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addTotalDeviseField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("T_DEVISE")) {
            t.addColumn("T_DEVISE", "bigint default 0");
            alter = true;
        } else {
            table.getBase().getDataSource().execute("UPDATE " + table.getSQLName().quote() + " SET \"T_DEVISE\"=0 WHERE \"T_DEVISE\" IS NULL");
            t.alterColumn("T_DEVISE", EnumSet.allOf(SQLField.Properties.class), "bigint", "0", false);
        }
        if (!table.getFieldsName().contains("T_POIDS")) {
            t.addColumn("T_POIDS", "real default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_TARIF")) {
            t.addForeignColumn("ID_TARIF", root.findTable("TARIF"));
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addTarifField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("QTE_ACHAT")) {
            t.addColumn("QTE_ACHAT", "integer DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("CODE_DOUANIER")) {
            t.addVarCharColumn("CODE_DOUANIER", 256);
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_PAYS")) {
            t.addForeignColumn("ID_PAYS", root.findTable("PAYS"));
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.findTable("DEVISE"));
            alter = true;
        }
        if (!table.getFieldsName().contains("PV_U_DEVISE")) {
            t.addColumn("PV_U_DEVISE", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("POURCENT_REMISE")) {
            t.addColumn("POURCENT_REMISE", "numeric(6,2) default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("PV_T_DEVISE")) {
            t.addColumn("PV_T_DEVISE", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("TAUX_DEVISE")) {
            t.addColumn("TAUX_DEVISE", "numeric (16,8) DEFAULT 1");
            alter = true;
        }
        if (alter) {
            try {
                root.getDBSystemRoot().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void updateSocieteSchema(DBRoot root) throws SQLException {
        DBSystemRoot sysRoot = root.getDBSystemRoot();
        SQLDataSource ds = sysRoot.getDataSource();
        System.out.println("InstallationPanel.InstallationPanel() UPDATE COMMERCIAL " + root);
        SQLTable tableCommercial = root.getTable("COMMERCIAL");
        CorrectOrder orderCorrect = new CorrectOrder(sysRoot);
        orderCorrect.change(tableCommercial);
        new AddFK(sysRoot).change(root);
        root.getSchema().updateVersion();
        root.refetch();
        sysRoot.getGraph();
        try {
            SQLTable tableArticle = root.getTable("ARTICLE");
            if (!tableArticle.getFieldsName().contains("INFOS")) {
                AlterTable t = new AlterTable(tableArticle);
                t.addVarCharColumn("INFOS", 2048);
                try {
                    ds.execute(t.asString());
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Erreur lors de l'ajout du champ INFO \u00e0 la table ARTICLE", ex);
                }
            }
            if (sysRoot.getServer().getSQLSystem().equals((Object)SQLSystem.POSTGRESQL)) {
                SQLTable tableCaisse = root.getTable("CAISSE");
                FixSerial f = new FixSerial(sysRoot);
                try {
                    f.change(tableCaisse);
                }
                catch (SQLException e2) {
                    throw new IllegalStateException("Erreur lors la mise \u00e0 jours des sequences de la table CAISSE", e2);
                }
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE TICKET_CAISSE " + root);
            SQLTable tableTicket = root.getTable("TICKET_CAISSE");
            if (!tableTicket.getFieldsName().contains("ID_MOUVEMENT")) {
                AlterTable t = new AlterTable(tableTicket);
                t.addForeignColumn("ID_MOUVEMENT", root.getTable("MOUVEMENT"));
                try {
                    ds.execute(t.asString());
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Erreur lors de l'ajout du champ ID_MOUVEMENT \u00e0 la table TICKET_CAISSE", ex);
                }
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE TYPE_REGLEMENT " + root);
            SQLTable tableReglmt = root.getTable("TYPE_REGLEMENT");
            SQLSelect sel = new SQLSelect(tableReglmt.getBase());
            sel.addSelect(tableReglmt.getKey());
            sel.setWhere(new Where((FieldRef)tableReglmt.getField("NOM"), "=", "Virement"));
            List l = ds.executeCol(sel.asString());
            if (l.size() == 0) {
                SQLRowValues rowVals = new SQLRowValues(tableReglmt);
                rowVals.put("NOM", "Virement");
                rowVals.put("COMPTANT", Boolean.FALSE);
                rowVals.put("ECHEANCE", Boolean.FALSE);
                try {
                    rowVals.commit();
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Erreur lors de l'ajout du type de paiement par virement", e);
                }
            }
            SQLSelect sel2 = new SQLSelect(tableReglmt.getBase());
            sel2.addSelect(tableReglmt.getKey());
            sel2.setWhere(new Where((FieldRef)tableReglmt.getField("NOM"), "=", "CESU"));
            List l2 = ds.executeCol(sel2.asString());
            if (l2.size() == 0) {
                SQLRowValues rowVals = new SQLRowValues(tableReglmt);
                rowVals.put("NOM", "CESU");
                rowVals.put("COMPTANT", Boolean.FALSE);
                rowVals.put("ECHEANCE", Boolean.FALSE);
                try {
                    rowVals.commit();
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Erreur lors de l'ajout du type CESU", e);
                }
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE FAMILLE_ARTICLE " + root);
            SQLTable tableFam = root.getTable("FAMILLE_ARTICLE");
            int nomSize = 256;
            if (tableFam.getField("NOM").getType().getSize() < 256) {
                AlterTable t = new AlterTable(tableFam);
                t.alterColumn("NOM", EnumSet.allOf(SQLField.Properties.class), "varchar(256)", "''", false);
                try {
                    ds.execute(t.asString());
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Erreur lors de la modification du champs NOM sur la table FAMILLE_ARTICLE", ex);
                }
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE FROM 1.0 " + root);
            ArrayList<ChangeTable> changes = new ArrayList<ChangeTable>();
            ArrayList<String> tablesToRemove = new ArrayList<String>();
            tablesToRemove.add("AFFAIRE");
            tablesToRemove.add("RAPPORT");
            tablesToRemove.add("CODE_MISSION");
            tablesToRemove.add("FICHE_RENDEZ_VOUS");
            tablesToRemove.add("NATURE_MISSION");
            tablesToRemove.add("AVIS_INTERVENTION");
            tablesToRemove.add("POURCENT_CCIP");
            tablesToRemove.add("SECRETAIRE");
            tablesToRemove.add("FICHE_RENDEZ_VOUS_ELEMENT");
            tablesToRemove.add("POURCENT_SERVICE");
            tablesToRemove.add("PROPOSITION");
            tablesToRemove.add("AFFAIRE_ELEMENT");
            tablesToRemove.add("PROPOSITION_ELEMENT");
            tablesToRemove.add("POLE_PRODUIT");
            tablesToRemove.add("BANQUE_POLE_PRODUIT");
            tablesToRemove.add("AFFACTURAGE");
            tablesToRemove.add("SECTEUR_ACTIVITE");
            DatabaseGraph graph = sysRoot.getGraph();
            for (String tableName : tablesToRemove) {
                if (!root.contains(tableName)) continue;
                SQLTable table = root.getTable(tableName);
                for (Link link : graph.getReferentLinks(table)) {
                    if (((SQLTable)link.getSource()).getDBRoot() == root && tablesToRemove.contains(((SQLTable)link.getSource()).getName())) continue;
                    AlterTable alter = new AlterTable((SQLTable)link.getSource());
                    alter.dropForeignColumns(link);
                    changes.add(alter);
                }
                changes.add(new DropTable(table));
            }
            List<String> alterRequests = ChangeTable.cat(changes, root.getName());
            try {
                for (String req : alterRequests) {
                    ds.execute(req);
                }
            }
            catch (Exception e1) {
                throw new IllegalStateException("Erreur lors de la mise \u00e0 jour des tables v1.0", e1);
            }
            System.out.println("InstallationPanel.InstallationPanel() UPDATE CAISSE " + root);
            try {
                SQLTable.setUndefID(tableTicket.getSchema(), tableTicket.getName(), 1);
                SQLTable.setUndefID(tableTicket.getSchema(), "CAISSE", 1);
            }
            catch (SQLException e1) {
                throw new IllegalStateException("Erreur lors de la mise \u00e0 jour des ind\u00e9finis de la table CAISSE", e1);
            }
        }
        finally {
            root.getSchema().updateVersion();
            root.refetch();
        }
    }

    private void updateVariablePaye(SQLTable table, String var, double value) throws SQLException {
        if (table == null) {
            throw new IllegalArgumentException("null table");
        }
        SQLSelect sel = new SQLSelect(table.getBase());
        sel.addSelectStar(table);
        sel.setWhere(new Where((FieldRef)table.getField("NOM"), "=", var));
        List l = (List)table.getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        for (SQLRow sqlRow : l) {
            SQLRowValues rowVals = sqlRow.asRowValues();
            rowVals.put("VALEUR", value);
            rowVals.update();
        }
    }
}

